const fs = require('fs-extra');
const path = require('path');

async function copyAssets() {
    try {
        console.log('🚀 Starting asset copying process...');
        
        // إنشاء المجلدات الأساسية
        const publicJs = path.resolve(__dirname, '../public/js');
        const publicCss = path.resolve(__dirname, '../public/css');
        
        await fs.ensureDir(publicJs);
        await fs.ensureDir(publicCss);
        
        // نسخ TinyMCE
        console.log('📝 Copying TinyMCE...');
        const tinymceSrc = path.resolve(__dirname, '../node_modules/tinymce');
        const tinymceDest = path.join(publicJs, 'tinymce');
        
        if (await fs.pathExists(tinymceSrc)) {
            await fs.copy(tinymceSrc, tinymceDest, {
                filter: (src, dest) => {
                    // تصفية الملفات غير المطلوبة
                    if (src.includes('package.json') || 
                        src.includes('README') || 
                        src.includes('.md') ||
                        src.includes('changelog') ||
                        src.includes('license')) {
                        return false;
                    }
                    return true;
                }
            });
            console.log('✅ TinyMCE copied successfully');
        } else {
            console.warn('⚠️  TinyMCE not found');
        }
        
        // نسخ Tom Select
        console.log('🔽 Copying Tom Select...');
        const tomSelectSrc = path.resolve(__dirname, '../node_modules/tom-select/dist');
        
        // نسخ ملف JavaScript
        const jsSource = path.join(tomSelectSrc, 'js/tom-select.complete.min.js');
        const jsDest = path.join(publicJs, 'tom-select.js');
        
        if (await fs.pathExists(jsSource)) {
            await fs.copy(jsSource, jsDest);
            console.log('✅ Tom Select JS copied successfully');
        } else {
            console.warn('⚠️  Tom Select JS file not found');
        }
        
        // نسخ ملف CSS
        const cssSource = path.join(tomSelectSrc, 'css/tom-select.default.min.css');
        const cssDest = path.join(publicCss, 'tom-select.css');
        
        if (await fs.pathExists(cssSource)) {
            await fs.copy(cssSource, cssDest);
            console.log('✅ Tom Select CSS copied successfully');
        } else {
            console.warn('⚠️  Tom Select CSS file not found');
        }
        
        // نسخ ملف التهيئة المحسن إذا كان موجوداً
        const initScriptSrc = path.resolve(__dirname, '../resources/js/tom-select-init.js');
        const initScriptDest = path.join(publicJs, 'tom-select-init.js');
        
        if (await fs.pathExists(initScriptSrc)) {
            await fs.copy(initScriptSrc, initScriptDest);
            console.log('✅ Tom Select init script copied');
        } else {
            // إنشاء ملف التهيئة الأساسي إذا لم يكن موجوداً
            const basicInitScript = `
// Tom Select Basic Initialization
document.addEventListener('DOMContentLoaded', function() {
    console.log('Tom Select ready');
});
            `;
            await fs.writeFile(initScriptDest, basicInitScript);
            console.log('✅ Basic Tom Select init script created');
        }
        
        // إنشاء ملف معلومات للتحقق من النسخة
        const versionInfo = {
            timestamp: new Date().toISOString(),
            tinymce: getPackageVersion('tinymce'),
            tomSelect: getPackageVersion('tom-select'),
            files: {
                tinymce: await fs.pathExists(tinymceDest),
                tomSelectJs: await fs.pathExists(jsDest),
                tomSelectCss: await fs.pathExists(cssDest),
                tomSelectInit: await fs.pathExists(initScriptDest)
            }
        };
        
        await fs.writeJSON(path.join(publicJs, 'asset-versions.json'), versionInfo, { spaces: 2 });
        
        console.log('🎉 All assets copied successfully!');
        console.log('📊 Version info:', versionInfo);
        
        // التحقق من الملفات المطلوبة
        const requiredFiles = [
            { path: jsDest, name: 'Tom Select JS' },
            { path: cssDest, name: 'Tom Select CSS' },
            { path: path.join(tinymceDest, 'tinymce.min.js'), name: 'TinyMCE JS' }
        ];
        
        console.log('\n📋 File verification:');
        for (const file of requiredFiles) {
            const exists = await fs.pathExists(file.path);
            console.log(`${exists ? '✅' : '❌'} ${file.name}: ${exists ? 'Found' : 'Missing'}`);
        }
        
    } catch (error) {
        console.error('❌ Error copying assets:', error);
        process.exit(1);
    }
}

function getPackageVersion(packageName) {
    try {
        const packagePath = path.resolve(__dirname, `../node_modules/${packageName}/package.json`);
        const packageJson = require(packagePath);
        return packageJson.version;
    } catch (error) {
        return 'unknown';
    }
}

// تشغيل الدالة
copyAssets();const fs = require('fs-extra');
const path = require('path');

async function copyAssets() {
    try {
        console.log('🚀 Starting asset copying process...');
        
        // إنشاء المجلدات الأساسية
        const publicJs = path.resolve(__dirname, '../public/js');
        const publicCss = path.resolve(__dirname, '../public/css');
        
        await fs.ensureDir(publicJs);
        await fs.ensureDir(publicCss);
        
        // نسخ TinyMCE
        console.log('📝 Copying TinyMCE...');
        const tinymceSrc = path.resolve(__dirname, '../node_modules/tinymce');
        const tinymceDest = path.join(publicJs, 'tinymce');
        
        if (await fs.pathExists(tinymceSrc)) {
            await fs.copy(tinymceSrc, tinymceDest, {
                filter: (src, dest) => {
                    // تصفية الملفات غير المطلوبة
                    if (src.includes('package.json') || 
                        src.includes('README') || 
                        src.includes('.md') ||
                        src.includes('changelog') ||
                        src.includes('license')) {
                        return false;
                    }
                    return true;
                }
            });
            console.log('✅ TinyMCE copied successfully');
        } else {
            console.warn('⚠️  TinyMCE not found');
        }
        
        // نسخ Tom Select
        console.log('🔽 Copying Tom Select...');
        const tomSelectSrc = path.resolve(__dirname, '../node_modules/tom-select/dist');
        
        // نسخ ملف JavaScript
        const jsSource = path.join(tomSelectSrc, 'js/tom-select.complete.min.js');
        const jsDest = path.join(publicJs, 'tom-select.js');
        
        if (await fs.pathExists(jsSource)) {
            await fs.copy(jsSource, jsDest);
            console.log('✅ Tom Select JS copied successfully');
        } else {
            console.warn('⚠️  Tom Select JS file not found');
        }
        
        // نسخ ملف CSS
        const cssSource = path.join(tomSelectSrc, 'css/tom-select.default.min.css');
        const cssDest = path.join(publicCss, 'tom-select.css');
        
        if (await fs.pathExists(cssSource)) {
            await fs.copy(cssSource, cssDest);
            console.log('✅ Tom Select CSS copied successfully');
        } else {
            console.warn('⚠️  Tom Select CSS file not found');
        }
        
        // إنشاء ملف معلومات للتحقق من النسخة
        const versionInfo = {
            timestamp: new Date().toISOString(),
            tinymce: getPackageVersion('tinymce'),
            tomSelect: getPackageVersion('tom-select')
        };
        
        await fs.writeJSON(path.join(publicJs, 'asset-versions.json'), versionInfo, { spaces: 2 });
        
        console.log('🎉 All assets copied successfully!');
        console.log('📊 Version info:', versionInfo);
        
    } catch (error) {
        console.error('❌ Error copying assets:', error);
        process.exit(1);
    }
}

function getPackageVersion(packageName) {
    try {
        const packagePath = path.resolve(__dirname, `../node_modules/${packageName}/package.json`);
        const packageJson = require(packagePath);
        return packageJson.version;
    } catch (error) {
        return 'unknown';
    }
}

// تشغيل الدالة
copyAssets();