@props([
    'name' => null,
    'label' => null,
    'checked' => false,
    'disabled' => false,
    'size' => 'md',
    'variant' => 'primary',
    'description' => null,
    'required' => false,
])

@php
$id = $attributes->get('id') ?? $name ?? 'toggle-' . uniqid();

// Flowbite sizes  
$sizes = match($size) {
    'sm' => 'w-9 h-5 after:h-4 after:w-4',
    'lg' => 'w-14 h-7 after:h-6 after:w-6', 
    default => 'w-11 h-6 after:h-5 after:w-5',
};

// Color variants
$colors = match($variant) {
    'primary' => 'peer-checked:bg-blue-600',
    'secondary' => 'peer-checked:bg-gray-600',
    'success' => 'peer-checked:bg-green-600',
    'warning' => 'peer-checked:bg-yellow-600',
    'danger' => 'peer-checked:bg-red-600',
    default => 'peer-checked:bg-blue-600',
};
@endphp

<div class="toggle-wrapper  gap-3" {{ $attributes->only(['class', 'x-data', 'x-show']) }}>
    
    <!-- Toggle Switch -->
    <label class="toggle-label relative inline-flex items-center {{ $disabled ? 'cursor-not-allowed opacity-60' : 'cursor-pointer' }}">
        <!-- Hidden input for unchecked state (sends 0) -->
        @if($name)
            <input type="hidden" name="{{ $name }}" value="0">
        @endif

        <input
            type="checkbox"
            id="{{ $id }}"
            @if($name) name="{{ $name }}" @endif
            class="sr-only peer"
            value="1"
            @if($checked) checked @endif
            @if($disabled) disabled @endif
            @if($required) required @endif
            {{ $attributes->except(['class', 'id', 'x-data', 'x-show']) }}
        >

        <div class="toggle-track relative {{ $sizes }} bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 {{ $colors }} peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:transition-all dark:border-gray-600"></div>
    </label>

    <!-- Label & Description -->
    @if($label || $description)
        <div class="toggle-content flex-1">
            @if($label)
                <label for="{{ $id }}" class="toggle-text block text-sm font-medium {{ $disabled ? 'cursor-not-allowed' : 'cursor-pointer' }}">
                    {{ $label }}
                    @if($required)
                        <span class="text-red-500">*</span>
                    @endif
                </label>
            @endif
            
            @if($description)
                <p class="toggle-description text-xs mt-1">
                    {{ $description }}
                </p>
            @endif
        </div>
    @endif
</div>