@props([
    'label' => null,
    'name' => null,
    'error' => null,
    'hint' => null,
    'required' => false,
    'disabled' => false,
    'rows' => 4,
])

@php
$id = $attributes->get('id') ?? $name ?? 'textarea-' . uniqid();
$textareaClasses = 'input';

if ($error) {
    $textareaClasses .= ' error';
}

$textareaClasses .= ' ' . ($attributes->get('class') ?? '');
@endphp

<div class="w-full">
    @if($label)
        <label for="{{ $id }}" class="block text-sm font-semibold mb-2 text-primary">
            {{ $label }}
            @if($required)
                <span class="text-red-500">*</span>
            @endif
        </label>
    @endif

    <textarea
        id="{{ $id }}"
        name="{{ $name }}"
        rows="{{ $rows }}"
        {{ $attributes->merge(['class' => $textareaClasses]) }}
        @if($required) required @endif
        @if($disabled) disabled @endif
    >{{ $slot }}</textarea>

    @if($error)
        <p class="mt-2 text-xs flex items-center gap-1.5" style="color: var(--color-danger-500);">
            <i data-lucide="alert-circle" class="w-4 h-4"></i>
            {{ $error }}
        </p>
    @endif

    @if($hint && !$error)
        <p class="mt-2 text-xs text-tertiary">
            {{ $hint }}
        </p>
    @endif
</div>