@props([
    'align' => 'auto', // auto, left, right, center
    'type' => 'text', // text, number, badge, actions
])

@php
$isRtl = app()->getLocale() === 'ar' || is_rtl();

// Smart alignment based on type and locale
$alignment = match($align) {
    'left' => 'left',
    'right' => 'right', 
    'center' => 'center',
    'auto' => match($type) {
        'actions' => 'center',
        'number' => 'center',
        'badge' => 'center',
        'text' => ($isRtl ? 'center' : 'center'),
        default => ($isRtl ? 'center' : 'center')
    },
    default => ($isRtl ? 'center' : 'center')
};

$classes = "px-4 py-3 text-{$alignment} " . ($attributes->get('class') ?? '');
@endphp

<td {{ $attributes->merge(['class' => $classes]) }}>
    {{ $slot }}
</td>