@props([
    'href' => '#',
    'icon',
    'label',
    'active' => false,
    'badge' => null,
])

<a 
    href="{{ $href }}" 
    class="flex items-center gap-3 px-3 py-2.5 rounded-xl transition-all {{ $active ? 'active-menu-item' : 'menu-item' }}"
    @if(!$active)
    onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
    onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'"
    @endif
>
    <i data-lucide="{{ $icon }}" class="w-5 h-5 flex-shrink-0"></i>
    <span x-show="$store.sidebar.open" x-cloak class="font-medium flex-1">{{ $label }}</span>
    @if($badge)
        <x-badge variant="danger" x-show="$store.sidebar.open" x-cloak>{{ $badge }}</x-badge>
    @endif
</a>