@props([
    'label' => null,
    'name' => null,
    'error' => null,
    'hint' => null,
    'required' => false,
    'disabled' => false,
    'placeholder' => null,
])

@php
$id = $attributes->get('id') ?? $name ?? 'select-' . uniqid();
$selectClasses = 'input appearance-none';

if ($error) {
    $selectClasses .= ' error';
}

$selectClasses .= ' ' . ($attributes->get('class') ?? '');

// Icon positioning with RTL support
$iconClasses = is_rtl() ? 'left-0 pl-3' : 'right-0 pr-3';
$inputPadding = is_rtl() ? 'pr-10' : 'pl-10';
$selectClasses .= ' ' . $inputPadding;
@endphp

<div class="w-full">
    @if($label)
        <label for="{{ $id }}" class="block text-sm font-semibold mb-2 text-primary">
            {{ $label }}
            @if($required)
                <span class="text-red-500">*</span>
            @endif
        </label>
    @endif

    <div class="relative">
        <select
            id="{{ $id }}"
            name="{{ $name }}"
            {{ $attributes->merge(['class' => $selectClasses]) }}
            @if($required) required @endif
            @if($disabled) disabled @endif
        >
            @if($placeholder)
                <option value="">{{ $placeholder }}</option>
            @endif
            {{ $slot }}
        </select>

        <!-- Custom Arrow Icon -->
        <div class="absolute inset-y-0 {{ $iconClasses }} flex items-center pointer-events-none">
            <i data-lucide="chevron-down" class="w-5 h-5 text-tertiary"></i>
        </div>
    </div>

    @if($error)
        <p class="mt-2 text-xs flex items-center gap-1.5" style="color: var(--color-danger-500);">
            <i data-lucide="alert-circle" class="w-4 h-4"></i>
            {{ $error }}
        </p>
    @endif

    @if($hint && !$error)
        <p class="mt-2 text-xs text-tertiary">
            {{ $hint }}
        </p>
    @endif
</div>

<style>
/* إخفاء الـ arrow الافتراضي للـ browser */
select {
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    background-image: none;
}

/* للتأكد في الـ Safari */
select::-ms-expand {
    display: none;
}

/* للتأكد في Firefox */
select:-moz-focusring {
    color: transparent;
    text-shadow: 0 0 0 var(--color-text-primary);
}
</style>    