@props([
    'placeholder' => 'بحث...',
    'value' => '',
    'name' => 'search',
])

<div class="relative w-full max-w-md" x-data="{ hasValue: false }">
    <div class="absolute inset-y-0 {{ is_rtl() ? 'left-0 pl-3' : 'right-0 pr-3' }} flex items-center pointer-events-none">
        <i data-lucide="search" class="w-5 h-5 text-tertiary"></i>
    </div>
    <input
        type="text"
        name="{{ $name }}"
        value="{{ $value }}"
        placeholder="{{ $placeholder }}"
        class="input {{ is_rtl() ? 'pr-10' : 'pl-10' }} focus:ring-2 focus:ring-primary/20"
        @input="hasValue = $event.target.value.length > 0"
        x-ref="searchInput"
        {{ $attributes }}
    >
    <div x-show="hasValue" 
         class="absolute inset-y-0 {{ is_rtl() ? 'right-0 pr-3' : 'left-0 pl-3' }} flex items-center">
        <button type="button" 
                @click="$refs.searchInput.value = ''; hasValue = false; $refs.searchInput.focus()"
                class="p-1 rounded-full hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors">
            <i data-lucide="x" class="w-4 h-4 text-tertiary"></i>
        </button>
    </div>
</div>