@props([
    'label' => 'فلتر',
    'options' => [],
    'selected' => '',
    'multiple' => false,
])

<div x-data="{ open: false }" class="relative">
    <button @click="open = !open" 
            class="flex items-center gap-2 px-4 py-2 rounded-lg border transition-all hover:bg-primary-light"
            style="border-color: var(--color-border); background: var(--color-bg-primary);">
        <i data-lucide="filter" class="w-4 h-4"></i>
        <span class="text-sm font-medium text-primary">{{ $label }}</span>
        <i data-lucide="chevron-down" class="w-4 h-4 text-tertiary transition-transform" 
           :class="open ? 'rotate-180' : ''"></i>
    </button>

    <div x-show="open" 
         @click.away="open = false"
         x-transition
         class="absolute top-full mt-2 {{ is_rtl() ? 'right-0' : 'left-0' }} min-w-48 rounded-xl shadow-lg border z-50"
         style="background: var(--color-bg-primary); border-color: var(--color-border);">
        
        <div class="p-3 space-y-2">
            @foreach($options as $value => $text)
                <label class="flex items-center gap-2 p-2 rounded-lg hover:bg-primary-light cursor-pointer">
                    @if($multiple)
                        <input type="checkbox" value="{{ $value }}" class="checkbox">
                    @else
                        <input type="radio" name="filter" value="{{ $value }}" class="radio">
                    @endif
                    <span class="text-sm text-primary">{{ $text }}</span>
                </label>
            @endforeach
        </div>
        
        <div class="border-t p-3 flex gap-2" style="border-color: var(--color-border);">
            <x-button size="sm" variant="outline" @click="open = false" class="flex-1">
                إلغاء
            </x-button>
            <x-button size="sm" variant="primary" @click="open = false" class="flex-1">
                تطبيق
            </x-button>
        </div>
    </div>
</div>