@props([
    'headers' => [],
    'responsive' => true,
    'sortable' => false,
    'striped' => false,
])

@php
$isRtl = app()->getLocale() === 'ar' || is_rtl();
@endphp

<div class="w-full {{ $responsive ? 'overflow-x-auto' : '' }}">
    <table class="w-full" style="border-collapse: separate; border-spacing: 0;">
        @if(!empty($headers))
        <thead>
            <tr style="background: var(--color-bg-secondary);">
                @foreach($headers as $key => $header)
                    @php
                        $alignment = is_array($header) && isset($header['align']) 
                            ? $header['align'] 
                            : ($isRtl ? 'right' : 'left');
                        
                        $headerText = is_array($header) ? $header['text'] : $header;
                        $width = is_array($header) && isset($header['width']) ? $header['width'] : null;
                        $sortable = is_array($header) && isset($header['sortable']) ? $header['sortable'] : false;
                        $classes = is_array($header) && isset($header['class']) ? $header['class'] : '';
                    @endphp
                    
                    <th class="px-4 py-3 text-{{ $alignment }} text-xs font-semibold uppercase tracking-wider text-tertiary first:rounded-tl-xl last:rounded-tr-xl {{ $classes }}"
                        @if($width) style="width: {{ $width }};" @endif>
                        
                        @if($sortable)
                            <button class="flex items-center gap-1 hover:text-primary transition-colors">
                                {{ $headerText }}
                                <i data-lucide="chevrons-up-down" class="w-3 h-3"></i>
                            </button>
                        @else
                            {{ $headerText }}
                        @endif
                    </th>
                @endforeach
            </tr>
        </thead>
        @endif
        
        <tbody class="divide-y {{ $striped ? 'striped-table' : '' }}" 
               style="divide-color: var(--color-border-primary); background: var(--color-bg-primary);">
            {{ $slot }}
        </tbody>
    </table>
</div>

<style>
/* Striped table styles */
.striped-table tr:nth-child(even) {
    background-color: var(--color-bg-secondary);
}

.striped-table tr:hover {
    background-color: var(--color-primary-light) !important;
}

/* RTL specific adjustments */
[dir="rtl"] table th:first-child {
    border-radius: 0 12px 0 0;
}

[dir="rtl"] table th:last-child {
    border-radius: 12px 0 0 0;
}

[dir="ltr"] table th:first-child {
    border-radius: 12px 0 0 0;
}

[dir="ltr"] table th:last-child {
    border-radius: 0 12px 0 0;
}
</style>