@props([
    'headers' => [],
    'data' => [],
    'searchable' => true,
    'filterable' => true,
    'sortable' => true,
    'actions' => true,
])

<div x-data="dataTable()" class="w-full space-y-4">
    
    {{-- Search and Filters --}}
    <div class="flex flex-col sm:flex-row gap-4 justify-between items-start sm:items-center">
        @if($searchable)
            <x-search-input 
                placeholder="بحث في الجدول..."
                @input="search = $event.target.value"
            />
        @endif
        
        @if($filterable)
            <div class="flex gap-2">
                <x-filter-dropdown label="الحالة" :options="['active' => 'نشط', 'inactive' => 'غير نشط']" />
                <x-filter-dropdown label="النوع" :options="['type1' => 'نوع 1', 'type2' => 'نوع 2']" />
            </div>
        @endif
    </div>
    
    {{-- Table --}}
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="bg-secondary">
                    @foreach($headers as $key => $header)
                        <th class="px-4 py-3 text-{{ is_rtl() ? 'right' : 'left' }} text-xs font-semibold uppercase tracking-wider text-tertiary">
                            @if($sortable)
                                <button @click="sort('{{ $key }}')" 
                                        class="flex items-center gap-1 hover:text-primary transition-colors">
                                    {{ $header }}
                                    <i data-lucide="arrow-up-down" class="w-3 h-3"></i>
                                </button>
                            @else
                                {{ $header }}
                            @endif
                        </th>
                    @endforeach
                    
                    @if($actions)
                        <th class="px-4 py-3 text-center text-xs font-semibold uppercase tracking-wider text-tertiary">
                            الإجراءات
                        </th>
                    @endif
                </tr>
            </thead>
            <tbody class="divide-y" style="divide-color: var(--color-border-primary);">
                {{ $slot }}
            </tbody>
        </table>
    </div>
    

</div>

<script>
function dataTable() {
    return {
        search: '',
        sortBy: '',
        sortDirection: 'asc',
        
        sort(column) {
            if (this.sortBy === column) {
                this.sortDirection = this.sortDirection === 'asc' ? 'desc' : 'asc';
            } else {
                this.sortBy = column;
                this.sortDirection = 'asc';
            }
        }
    }
}
</script>