{{-- resources/views/components/dashboard-widget.blade.php --}}
@props([
    'title',
    'value' => null,
    'icon' => null,
    'gradient' => 'primary',
    'trend' => null,
    'trendValue' => null,
    'trendDirection' => 'up',
    'href' => null,
    'subtitle' => null,
    'badge' => null,
])

@php
$gradientClass = match($gradient) {
    'primary' => 'gradient-primary',
    'secondary' => 'gradient-secondary',
    'success' => 'bg-gradient-to-r from-green-500 to-green-600',
    'warning' => 'bg-gradient-to-r from-yellow-500 to-orange-600',
    'danger' => 'bg-gradient-to-r from-red-500 to-red-600',
    'info' => 'bg-gradient-to-r from-blue-500 to-blue-600',
    default => 'gradient-primary',
};

$trendVariant = match($trendDirection) {
    'up' => 'success',
    'down' => 'danger',
    'stable' => 'info',
    default => 'info',
};

$trendIcon = match($trendDirection) {
    'up' => 'trending-up',
    'down' => 'trending-down',
    'stable' => 'minus',
    default => 'minus',
};

$wrapperTag = $href ? 'a' : 'div';
$wrapperAttributes = $href ? "href=\"{$href}\"" : '';
@endphp

<{{ $wrapperTag }} {!! $wrapperAttributes !!} 
    class="card hover:shadow-xl transition-all hover:-translate-y-1 {{ $href ? 'cursor-pointer' : '' }}"
    {{ $attributes }}>
    
    <div class="flex items-center justify-between">
        <div class="flex-1">
            <div class="flex items-center justify-between mb-2">
                <p class="text-sm font-medium text-secondary">{{ $title }}</p>
                @if($badge)
                    <x-badge variant="{{ $badge['variant'] ?? 'primary' }}">{{ $badge['text'] }}</x-badge>
                @endif
            </div>
            
            @if($value)
                <h3 class="text-3xl font-bold text-primary">{{ $value }}</h3>
            @endif
            
            @if($subtitle)
                <p class="text-xs text-tertiary mt-1">{{ $subtitle }}</p>
            @endif
        </div>
        
        @if($icon)
            <div class="w-14 h-14 rounded-xl flex items-center justify-center {{ $gradientClass }} shadow-lg flex-shrink-0 ml-4">
                <i data-lucide="{{ $icon }}" class="w-7 h-7 text-white"></i>
            </div>
        @endif
    </div>
    
    @if($trend || $slot->isNotEmpty())
        <div class="mt-4">
            @if($trend)
                <div class="flex items-center gap-2">
                    <x-badge variant="{{ $trendVariant }}" icon="{{ $trendIcon }}">
                        {{ $trendValue ?? abs($trend) }}{{ is_numeric($trend) ? '%' : '' }}
                    </x-badge>
                    <span class="text-xs text-tertiary">{{ $trend }}</span>
                </div>
            @endif
            
            {{ $slot }}
        </div>
    @endif
    
</{{ $wrapperTag }}>

{{-- Chart Widget Component --}}
{{-- resources/views/components/dashboard-chart.blade.php --}}
@props([
    'title',
    'chartId',
    'type' => 'line', // line, bar, doughnut, pie
    'height' => '300px',
    'badge' => null,
    'description' => null,
])

<div class="card" {{ $attributes }}>
    <div class="flex items-center justify-between mb-6">
        <div>
            <h3 class="text-lg font-bold text-primary">{{ $title }}</h3>
            @if($description)
                <p class="text-sm text-secondary mt-1">{{ $description }}</p>
            @endif
        </div>
        @if($badge)
            <x-badge variant="{{ $badge['variant'] ?? 'info' }}">{{ $badge['text'] }}</x-badge>
        @endif
    </div>
    
    <div style="height: {{ $height }};">
        <canvas id="{{ $chartId }}"></canvas>
    </div>
    
    {{ $slot }}
</div>

{{-- Activity Item Component --}}
{{-- resources/views/components/dashboard-activity.blade.php --}}
@props([
    'icon',
    'iconColor' => 'primary',
    'title',
    'description',
    'time',
    'href' => null,
])

@php
$iconBgColor = match($iconColor) {
    'primary' => 'var(--color-primary-light)',
    'secondary' => 'var(--color-secondary-light)',
    'success' => 'var(--color-success-50)',
    'warning' => 'rgba(251, 191, 36, 0.1)',
    'danger' => 'var(--color-danger-50)',
    'info' => 'var(--color-info-50)',
    'purple' => 'rgba(139, 92, 246, 0.1)',
    default => 'var(--color-primary-light)',
};

$iconTextColor = match($iconColor) {
    'primary' => 'var(--color-primary)',
    'secondary' => 'var(--color-secondary)',
    'success' => 'var(--color-success-500)',
    'warning' => '#FBBF24',
    'danger' => 'var(--color-danger-500)',
    'info' => 'var(--color-info-500)',
    'purple' => '#8B5CF6',
    default => 'var(--color-primary)',
};

$wrapperTag = $href ? 'a' : 'div';
$wrapperAttributes = $href ? "href=\"{$href}\"" : '';
@endphp

<{{ $wrapperTag }} {!! $wrapperAttributes !!}
    class="flex items-start gap-4 p-4 rounded-xl transition-all {{ $href ? 'cursor-pointer hover:bg-primary-light' : '' }}"
    {{ $attributes }}>
    
    <div class="w-10 h-10 rounded-xl flex items-center justify-center flex-shrink-0" 
         style="background: {{ $iconBgColor }};">
        <i data-lucide="{{ $icon }}" class="w-5 h-5" style="color: {{ $iconTextColor }};"></i>
    </div>
    
    <div class="flex-1">
        <h4 class="font-semibold text-sm mb-1 text-primary">{{ $title }}</h4>
        <p class="text-sm text-secondary">{{ $description }}</p>
        <p class="text-xs mt-1.5 flex items-center gap-1 text-tertiary">
            <i data-lucide="clock" class="w-3 h-3"></i>
            {{ $time }}
        </p>
        
        {{ $slot }}
    </div>
</{{ $wrapperTag }}>

{{-- Quick Action Component --}}
{{-- resources/views/components/dashboard-action.blade.php --}}
@props([
    'title',
    'description',
    'count' => null,
    'icon',
    'variant' => 'primary',
    'href',
])

@php
$borderColor = match($variant) {
    'primary' => 'var(--color-primary)',
    'secondary' => 'var(--color-secondary)',
    'success' => 'var(--color-success-500)',
    'warning' => 'var(--color-warning-500)',
    'danger' => 'var(--color-danger-500)',
    'info' => 'var(--color-info-500)',
    default => 'var(--color-primary)',
};

$bgColor = match($variant) {
    'primary' => 'var(--color-primary-50)',
    'secondary' => 'var(--color-secondary-50)',
    'success' => 'var(--color-success-50)',
    'warning' => 'var(--color-warning-50)',
    'danger' => 'var(--color-danger-50)',
    'info' => 'var(--color-info-50)',
    default => 'var(--color-primary-50)',
};

$iconColor = match($variant) {
    'primary' => 'var(--color-primary-500)',
    'secondary' => 'var(--color-secondary-500)',
    'success' => 'var(--color-success-500)',
    'warning' => 'var(--color-warning-500)',
    'danger' => 'var(--color-danger-500)',
    'info' => 'var(--color-info-500)',
    default => 'var(--color-primary-500)',
};
@endphp

<a href="{{ $href }}" 
   class="p-4 rounded-xl border transition-all hover:shadow-md hover:-translate-y-1"
   style="border-color: var(--color-border); background: var(--color-bg-primary);"
   onmouseover="this.style.borderColor='{{ $borderColor }}'"
   onmouseout="this.style.borderColor='var(--color-border)'"
   {{ $attributes }}>
    
    <div class="flex items-center gap-3">
        <div class="w-10 h-10 rounded-lg flex items-center justify-center" 
             style="background: {{ $bgColor }};">
            <i data-lucide="{{ $icon }}" class="w-5 h-5" style="color: {{ $iconColor }};"></i>
        </div>
        
        <div class="flex-1">
            <h4 class="font-semibold text-sm text-primary">{{ $title }}</h4>
            <p class="text-xs text-secondary mt-1">{{ $description }}</p>
        </div>
        
        @if($count)
            <x-badge variant="{{ $variant }}">{{ $count }}</x-badge>
        @endif
    </div>
    
    {{ $slot }}
</a>