@props([
    'name' => 'confirm',
    'title' => 'Are you sure?',
    'message' => 'This action cannot be undone.',
    'confirmText' => 'Confirm',
    'cancelText' => 'Cancel',
    'confirmVariant' => 'danger',
    'icon' => 'alert-triangle',
    'iconColor' => 'danger',
])

@php
$iconColorClass = match($iconColor) {
    'danger' => 'var(--color-danger-500)',
    'warning' => 'var(--color-warning-500)',
    'primary' => 'var(--color-primary-500)',
    'secondary' => 'var(--color-secondary-500)',
    default => 'var(--color-danger-500)',
};

$iconBgClass = match($iconColor) {
    'danger' => 'var(--color-danger-50)',
    'warning' => 'var(--color-warning-50)',
    'primary' => 'var(--color-primary-50)',
    'secondary' => 'var(--color-secondary-50)',
    default => 'var(--color-danger-50)',
};
@endphp

<x-modal :name="$name" maxWidth="sm">
    <div class="p-6">
        <!-- Icon -->
        <div class="mx-auto flex items-center justify-center h-14 w-14 rounded-2xl mb-4"
             style="background: {{ $iconBgClass }};">
            <i data-lucide="{{ $icon }}" class="w-7 h-7" style="color: {{ $iconColorClass }};"></i>
        </div>

        <!-- Title -->
        <h3 class="text-xl font-bold text-center mb-2 text-primary">
            {{ $title }}
        </h3>

        <!-- Message -->
        <p class="text-sm text-center mb-6 text-secondary">
            {{ $message }}
        </p>

        <!-- Actions -->
        <div class="flex flex-col-reverse sm:flex-row gap-3">
            <x-button 
                variant="outline" 
                class="flex-1"
                x-on:click="$dispatch('close-modal', '{{ $name }}')"
            >
                {{ $cancelText }}
            </x-button>

            <x-button 
                :variant="$confirmVariant"
                class="flex-1"
                x-on:click="$dispatch('confirm-action', '{{ $name }}'); $dispatch('close-modal', '{{ $name }}')"
            >
                {{ $confirmText }}
            </x-button>
        </div>
    </div>
</x-modal>