@props([
    'title' => null,
    'subtitle' => null,
    'icon' => null,
    'actions' => null,
    'padding' => true,
])

<div {{ $attributes->merge(['class' => 'card']) }}>
    @if($title || $subtitle || $icon || $actions)
        <div class="flex items-center justify-between {{ $padding ? 'mb-6' : '' }}">
            <div class="flex items-center gap-3">
                @if($icon)
                    <div class="w-10 h-10 rounded-xl flex items-center justify-center gradient-primary">
                        <i data-lucide="{{ $icon }}" class="w-5 h-5 text-white"></i>
                    </div>
                @endif
                <div>
                    @if($title)
                        <h3 class="text-lg font-bold text-primary">{{ $title }}</h3>
                    @endif
                    @if($subtitle)
                        <p class="text-sm text-secondary">{{ $subtitle }}</p>
                    @endif
                </div>
            </div>
            @if($actions)
                <div class="flex items-center gap-2">
                    {{ $actions }}
                </div>
            @endif
        </div>
    @endif
    
    {{ $slot }}
</div>
