@props([
    'variant' => 'primary',
    'icon' => null,
])

@php
$classes = 'badge';

$classes .= match($variant) {
    'primary' => ' badge-primary',
    'secondary' => ' badge-secondary',
    'success' => ' badge-success',
    'warning' => ' badge-warning',
    'danger' => ' badge-danger',
    'info' => ' badge-info',
    default => ' badge-primary',
};

$classes .= ' ' . ($attributes->get('class') ?? '');
@endphp

<span {{ $attributes->merge(['class' => $classes]) }}>
    @if($icon)
        <i data-lucide="{{ $icon }}" class="w-3 h-3 mt-[1px]"></i>
    @endif
    {{ $slot }}
</span>