@props([
    'variant' => 'info',
    'icon' => null,
    'title' => null,
    'dismissible' => false,
])

@php
$config = match($variant) {
    'success' => [
        'bg' => 'var(--color-success-50)',
        'border' => 'var(--color-success-500)',
        'text' => 'var(--color-success-600)',
        'icon' => $icon ?? 'check-circle',
    ],
    'error', 'danger' => [
        'bg' => 'var(--color-danger-50)',
        'border' => 'var(--color-danger-500)',
        'text' => 'var(--color-danger-600)',
        'icon' => $icon ?? 'alert-circle',
    ],
    'warning' => [
        'bg' => 'var(--color-warning-50)',
        'border' => 'var(--color-warning-500)',
        'text' => 'var(--color-warning-600)',
        'icon' => $icon ?? 'alert-triangle',
    ],
    default => [
        'bg' => 'var(--color-info-50)',
        'border' => 'var(--color-info-500)',
        'text' => 'var(--color-info-600)',
        'icon' => $icon ?? 'info',
    ],
};
@endphp

<div 
    x-data="{ show: true }"
    x-show="show"
    x-transition
    class="p-4 rounded-xl border flex items-start gap-3"
    style="background: {{ $config['bg'] }}; border-color: {{ $config['border'] }};"
    {{ $attributes }}
>
    <i data-lucide="{{ $config['icon'] }}" class="w-5 h-5 flex-shrink-0 mt-2" style="color: {{ $config['text'] }};"></i>
    
    <div class="flex-1 min-w-0">
        @if($title)
            <h4 class="font-semibold text-sm mb-1" style="color: {{ $config['text'] }};">{{ $title }}</h4>
        @endif
        <div class="text-sm" style="color: {{ $config['text'] }};">
            {{ $slot }}
        </div>
    </div>

    @if($dismissible)
        <button 
            @click="show = false"
            class="flex-shrink-0 p-1 rounded-lg transition-colors hover:bg-black/5"
            style="color: {{ $config['text'] }};"
        >
            <i data-lucide="x" class="w-4 h-4"></i>
        </button>
    @endif
</div>