@props([
    'icon' => null,
    'variant' => 'default',
    'href' => null,
])

@php
$textColor = match($variant) {
    'danger' => 'text-red-600',
    'warning' => 'text-yellow-600',
    'success' => 'text-green-600',
    default => 'text-primary',
};
@endphp

@if($href)
    <a href="{{ $href }}" 
       class="flex items-center gap-2 px-4 py-2 text-sm hover:bg-primary-light transition-colors {{ $textColor }}"
       {{ $attributes }}>
        @if($icon)
            <i data-lucide="{{ $icon }}" class="w-4 h-4"></i>
        @endif
        {{ $slot }}
    </a>
@else
    <button class="w-full flex items-center gap-2 px-4 py-2 text-sm hover:bg-primary-light transition-colors {{ $textColor }}"
            {{ $attributes }}>
        @if($icon)
            <i data-lucide="{{ $icon }}" class="w-4 h-4"></i>
        @endif
        {{ $slot }}
    </button>
@endif