@props([
    'align' => 'right',
])

<div x-data="{ open: false }" class="relative">
    <button @click="open = !open" 
            class="p-2 rounded-lg hover:bg-primary-light transition-colors">
        <i data-lucide="more-horizontal" class="w-4 h-4 text-tertiary"></i>
    </button>
    
    <div x-show="open" 
         @click.away="open = false"
         x-transition
         class="absolute top-full mt-1 {{ $align === 'left' ? 'left-0' : 'right-0' }} min-w-32 rounded-lg shadow-lg border z-50"
         style="background: var(--color-bg-primary); border-color: var(--color-border);">
        
        <div class="py-1">
            {{ $slot }}
        </div>
    </div>
</div>