@extends('admin.layouts.app')

@section('title', admin_trans('my_profile'))
@section('page-title', admin_trans('my_profile'))

@section('content')

<div class="space-y-6" x-data="profilePage()">

    <!-- Header -->
    <div class="flex items-center gap-4">
        <div class="w-16 h-16 rounded-2xl flex items-center justify-center text-white font-bold gradient-primary text-2xl">
            {{ substr(auth()->user()->name, 0, 1) }}
        </div>
        <div>
            <h1 class="text-2xl font-bold text-primary">{{ auth()->user()->name }}</h1>
            <p class="text-sm text-tertiary">{{ auth()->user()->email }}</p>
            <x-badge variant="success" class="mt-1">{{ admin_trans('admin') }}</x-badge>
        </div>
    </div>

    <!-- Profile Information -->
    <x-card title="{{ admin_trans('profile_information') }}" icon="user">
        <form method="POST" action="{{ route('admin.profile.update') }}" class="space-y-6">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Name -->
                <x-input 
                    :label="admin_trans('full_name')" 
                    name="name" 
                    :required="true"
                    value="{{ auth()->user()->name }}"
                    :error="$errors->first('name')"
                />

                <!-- Email -->
                <x-input 
                    :label="admin_trans('email')" 
                    name="email" 
                    type="email"
                    :required="true"
                    value="{{ auth()->user()->email }}"
                    :error="$errors->first('email')"
                />

                <!-- Role (Read-only) -->
                <x-input 
                    :label="admin_trans('role')" 
                    value="{{ admin_trans('admin') }}"
                    :disabled="true"
                    :hint="admin_trans('role_cannot_be_changed')"
                />

                <!-- Member Since -->
                <x-input 
                    :label="admin_trans('member_since')" 
                    value="{{ auth()->user()->created_at->format('Y-m-d') }}"
                    :disabled="true"
                />
            </div>

            <div class="flex gap-3 justify-end pt-4 border-t" style="border-color: var(--color-border);">
                <x-button variant="primary" type="submit" icon="check">
                    {{ admin_trans('save_changes') }}
                </x-button>
            </div>
        </form>
    </x-card>

    <!-- Change Password -->
    <x-card title="{{ admin_trans('change_password') }}" icon="lock">
        <form method="POST" action="{{ route('admin.profile.password') }}" class="space-y-6">
            @csrf
            @method('PUT')

            <div class="grid grid-cols-1 gap-6">
                <!-- Current Password -->
                <x-input 
                    :label="admin_trans('current_password')" 
                    name="current_password" 
                    type="password"
                    :required="true"
                    :error="$errors->password->first('current_password')"
                />

                <!-- New Password -->
                <x-input 
                    :label="admin_trans('new_password')" 
                    name="password" 
                    type="password"
                    :required="true"
                    :error="$errors->password->first('password')"
                    :hint="admin_trans('password_requirements')"
                />

                <!-- Confirm Password -->
                <x-input 
                    :label="admin_trans('confirm_password')" 
                    name="password_confirmation" 
                    type="password"
                    :required="true"
                    :error="$errors->password->first('password_confirmation')"
                />
            </div>

            <div class="flex gap-3 justify-end pt-4 border-t" style="border-color: var(--color-border);">
                <x-button variant="primary" type="submit" icon="key">
                    {{ admin_trans('update_password') }}
                </x-button>
            </div>
        </form>
    </x-card>

    <!-- Account Information -->
    <x-card title="{{ admin_trans('account_information') }}" icon="info">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- Account ID -->
            <div class="p-4 rounded-xl border" style="border-color: var(--color-border); background: var(--color-bg-secondary);">
                <div class="flex items-center gap-3 mb-2">
                    <i data-lucide="hash" class="w-5 h-5 text-primary"></i>
                    <span class="text-sm font-semibold text-primary">{{ admin_trans('account_id') }}</span>
                </div>
                <p class="text-lg font-bold text-primary">#{{ auth()->user()->id }}</p>
            </div>

            <!-- Email Verification Status -->
            <div class="p-4 rounded-xl border" style="border-color: var(--color-border); background: var(--color-bg-secondary);">
                <div class="flex items-center gap-3 mb-2">
                    <i data-lucide="mail" class="w-5 h-5 text-primary"></i>
                    <span class="text-sm font-semibold text-primary">{{ admin_trans('email_status') }}</span>
                </div>
                @if(auth()->user()->email_verified_at)
                    <x-badge variant="success" icon="check-circle">{{ admin_trans('verified') }}</x-badge>
                @else
                    <x-badge variant="warning" icon="alert-circle">{{ admin_trans('unverified') }}</x-badge>
                @endif
            </div>

            <!-- Last Login -->
            <div class="p-4 rounded-xl border" style="border-color: var(--color-border); background: var(--color-bg-secondary);">
                <div class="flex items-center gap-3 mb-2">
                    <i data-lucide="clock" class="w-5 h-5 text-primary"></i>
                    <span class="text-sm font-semibold text-primary">{{ admin_trans('last_activity') }}</span>
                </div>
                <p class="text-sm text-secondary">{{ auth()->user()->updated_at->diffForHumans() }}</p>
            </div>
        </div>
    </x-card>


    <!-- Security Settings -->
    <x-card title="{{ admin_trans('security_settings') }}" icon="shield">
        <div class="space-y-4">
            <div class="flex items-center justify-between p-4 rounded-xl border" style="border-color: var(--color-border); background: var(--color-bg-secondary);">
                <div class="flex items-center gap-3">
                    <i data-lucide="key" class="w-5 h-5 text-primary"></i>
                    <div>
                        <h4 class="font-semibold text-primary">{{ admin_trans('password_security') }}</h4>
                        <p class="text-sm text-secondary">{{ admin_trans('password_last_changed') }}: {{ auth()->user()->updated_at->format('Y-m-d') }}</p>
                    </div>
                </div>
                <x-badge variant="success" icon="check-circle">{{ admin_trans('secure') }}</x-badge>
            </div>

            <div class="flex items-center justify-between p-4 rounded-xl border" style="border-color: var(--color-border); background: var(--color-bg-secondary);">
                <div class="flex items-center gap-3">
                    <i data-lucide="mail-check" class="w-5 h-5 text-primary"></i>
                    <div>
                        <h4 class="font-semibold text-primary">{{ admin_trans('email_security') }}</h4>
                        <p class="text-sm text-secondary">{{ admin_trans('email_verified_on') }}: {{ auth()->user()->email_verified_at ? auth()->user()->email_verified_at->format('Y-m-d') : admin_trans('not_verified') }}</p>
                    </div>
                </div>
                @if(auth()->user()->email_verified_at)
                    <x-badge variant="success" icon="check-circle">{{ admin_trans('verified') }}</x-badge>
                @else
                    <x-badge variant="warning" icon="alert-circle">{{ admin_trans('unverified') }}</x-badge>
                @endif
            </div>

            <div class="flex items-center justify-between p-4 rounded-xl border" style="border-color: var(--color-border); background: var(--color-bg-secondary);">
                <div class="flex items-center gap-3">
                    <i data-lucide="user-x" class="w-5 h-5 text-primary"></i>
                    <div>
                        <h4 class="font-semibold text-primary">{{ admin_trans('account_status') }}</h4>
                        <p class="text-sm text-secondary">{{ admin_trans('account_created') }}: {{ auth()->user()->created_at->format('Y-m-d') }}</p>
                    </div>
                </div>
                <x-badge variant="success" icon="check-circle">{{ admin_trans('active') }}</x-badge>
            </div>
        </div>
    </x-card>

</div>

@endsection

@push('scripts')
<script>
function profilePage() {
    return {
        init() {
            // Profile page initialization
        }
    }
}

document.addEventListener('DOMContentLoaded', function() {
    if (typeof lucide !== 'undefined') {
        lucide.createIcons();
    }
});
</script>
@endpush