<!-- Mobile Overlay -->
<div x-show="$store.sidebar.open" @click="$store.sidebar.toggle()" x-cloak
    class="fixed inset-0 backdrop-blur-md z-40 lg:hidden" style="background: rgba(15, 23, 42, 0.1);"
    x-transition:enter="transition-all ease-out duration-300" x-transition:enter-start="opacity-0"
    x-transition:enter-end="opacity-100" x-transition:leave="transition-all ease-in duration-200"
    x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"></div>

<!-- Sidebar -->
<aside
    class="fixed lg:relative inset-y-0 {{ is_rtl() ? 'right-0' : 'left-0' }} z-50 transition-all duration-300 flex-shrink-0"
    :class="$store.sidebar.open ? 'translate-x-0 w-64' :
        '{{ is_rtl() ? 'translate-x-full' : '-translate-x-full' }} lg:translate-x-0 lg:w-20'"
    style="background: var(--color-bg-primary); border-{{ is_rtl() ? 'left' : 'right' }}: 1px solid var(--color-border);">
    <div class="h-full flex flex-col">

        <!-- Logo & Toggle -->
        <div class="h-16 flex items-center justify-between px-4 border-b-2" style="border-color: var(--color-border);">
            <!-- Logo -->
            <div class="flex items-center gap-3 overflow-hidden">
                <img src="{{ app_logo() }}" alt="{{ app_name() }}" :class="$store.sidebar.open ? 'h-10' : 'h-8'"
                    class="w-auto transition-all" onerror="this.src='/img/logo.svg'">
            </div>

            <!-- Toggle Button -->
            <button @click="$store.sidebar.toggle()" class="p-2 rounded-lg transition-all flex-shrink-0"
                style="background: var(--color-bg-secondary);"
                onmouseover="this.style.background='var(--color-primary-light)'; this.querySelector('i').style.color='var(--color-primary)'"
                onmouseout="this.style.background='var(--color-bg-secondary)'; this.querySelector('i').style.color='var(--color-text-primary)'">
                <i x-show="!$store.sidebar.open" data-lucide="menu" class="w-5 h-5 transition-colors"
                    style="color: var(--color-text-primary);"></i>
                <i x-show="$store.sidebar.open" x-cloak data-lucide="x" class="w-5 h-5 transition-colors"
                    style="color: var(--color-text-primary);"></i>
            </button>
        </div>

        <!-- Navigation -->
        <nav class="flex-1 overflow-y-auto py-4">
            <div class="px-3 space-y-6">

                <!-- Dashboard Section -->
                <div>
                    <a href="{{ route('admin.dashboard') }}"
                        class="flex items-center gap-3 px-3 py-2.5 rounded-xl transition-all {{ request()->routeIs('admin.dashboard') ? 'active-menu-item' : 'menu-item' }}"
                        @if (!request()->routeIs('admin.dashboard')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
                        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                        <i data-lucide="home" class="w-5 h-5 flex-shrink-0"></i>
                        <span x-show="$store.sidebar.open" x-cloak
                            class="font-medium">{{ admin_trans('dashboard') }}</span>
                    </a>

                    <!-- Settings -->
                    <a href="{{ route('admin.settings.index') }}"
                        class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.settings.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                        @if (!request()->routeIs('admin.settings.*')) onmouseover="this.style.background='var(--color-secondary-light)'; this.style.color='var(--color-secondary)'"
       onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                        <i data-lucide="settings" class="w-5 h-5 flex-shrink-0"></i>
                        <span x-show="$store.sidebar.open" x-cloak
                            class="font-medium">{{ admin_trans('settings') }}</span>
                    </a>
                </div>

                <!-- MAIN Section -->
                <div>
                    <h3 x-show="$store.sidebar.open" x-cloak
                        class="px-3 mb-2 text-xs font-bold uppercase tracking-wider"
                        style="color: var(--color-text-tertiary);">
                        {{ admin_trans('main') }}
                    </h3>

                    <div class="space-y-1">
                        <!-- Offers -->
                        <a href="{{ route('admin.offers.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.offers.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.offers.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="tag" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('offers') }}</span>
                        </a>

                        <!-- Stores -->
                        <a href="{{ route('admin.stores.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.stores.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.stores.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="store" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('stores') }}</span>
                        </a>

                        <!-- Occasions - Updated Link -->
                        <a href="{{ route('admin.occasions.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.occasions.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.occasions.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="calendar" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('occasions') }}</span>
                        </a>


                        <!-- Brands -->
                        <a href="{{ route('admin.brands.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.brands.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.brands.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="sparkles" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('brands') }}</span>
                        </a>
                    </div>
                </div>

                <!-- ANALYTICS Section -->
                <div x-data="{ analyticsOpen: {{ request()->routeIs('admin.analytics.*') ? 'true' : 'false' }} }">
                    <h3 x-show="$store.sidebar.open" x-cloak
                        class="px-3 mb-2 text-xs font-bold uppercase tracking-wider"
                        style="color: var(--color-text-tertiary);">
                        {{ admin_trans('analytics') }}
                    </h3>

                    <!-- Analytics Dropdown Toggle -->
                    <button @click="analyticsOpen = !analyticsOpen"
                        class="w-full flex items-center justify-between gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.analytics.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                        @if (!request()->routeIs('admin.analytics.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
                        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                        <div class="flex items-center gap-3">
                            <i data-lucide="bar-chart-3" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak class="font-medium">{{ admin_trans('analytics') }}</span>
                        </div>
                        <i x-show="$store.sidebar.open" x-cloak data-lucide="chevron-down" class="w-4 h-4 transition-transform"
                            :class="analyticsOpen ? 'rotate-180' : ''"></i>
                    </button>

                    <!-- Analytics Submenu -->
                    <div x-show="analyticsOpen && $store.sidebar.open" x-cloak x-collapse class="mt-1 ml-8 space-y-1">

                        <!-- Offers Analytics -->
                        <div x-data="{ offersOpen: {{ request()->routeIs('admin.analytics.offers.*') ? 'true' : 'false' }} }">
                            <button @click="offersOpen = !offersOpen"
                                class="w-full flex items-center justify-between px-3 py-2 rounded-lg text-sm transition-all"
                                style="color: var(--color-text-secondary);"
                                onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
                                onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'">
                                <span>{{ admin_trans('offers_analytics') }}</span>
                                <i data-lucide="chevron-down" class="w-3 h-3 transition-transform" :class="offersOpen ? 'rotate-180' : ''"></i>
                            </button>
                            <div x-show="offersOpen" x-cloak x-collapse class="ml-4 mt-1 space-y-1">
                                <a href="{{ route('admin.analytics.offers.by-status') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.offers.by-status') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('offers_by_status') }}
                                </a>
                                <a href="{{ route('admin.analytics.offers.by-type') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.offers.by-type') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('offers_by_type') }}
                                </a>
                                <a href="{{ route('admin.analytics.offers.by-store') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.offers.by-store') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('offers_by_store') }}
                                </a>
                                <a href="{{ route('admin.analytics.offers.by-brand') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.offers.by-brand') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('offers_by_brand') }}
                                </a>
                                <a href="{{ route('admin.analytics.offers.by-category') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.offers.by-category') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('offers_by_category') }}
                                </a>
                                <a href="{{ route('admin.analytics.offers.expiring-soon') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.offers.expiring-soon') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('offers_expiring_soon') }}
                                </a>
                                <a href="{{ route('admin.analytics.offers.most-popular') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.offers.most-popular') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('most_popular_offers') }}
                                </a>
                                <a href="{{ route('admin.analytics.offers.least-popular') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.offers.least-popular') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('least_popular_offers') }}
                                </a>
                                <a href="{{ route('admin.analytics.offers.usage-report') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.offers.usage-report') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('offers_usage_report') }}
                                </a>
                            </div>
                        </div>

                        <!-- Stores Analytics -->
                        <div x-data="{ storesOpen: {{ request()->routeIs('admin.analytics.stores.*') ? 'true' : 'false' }} }">
                            <button @click="storesOpen = !storesOpen"
                                class="w-full flex items-center justify-between px-3 py-2 rounded-lg text-sm transition-all"
                                style="color: var(--color-text-secondary);"
                                onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
                                onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'">
                                <span>{{ admin_trans('stores_analytics') }}</span>
                                <i data-lucide="chevron-down" class="w-3 h-3 transition-transform" :class="storesOpen ? 'rotate-180' : ''"></i>
                            </button>
                            <div x-show="storesOpen" x-cloak x-collapse class="ml-4 mt-1 space-y-1">
                                <a href="{{ route('admin.analytics.stores.by-country') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.stores.by-country') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('stores_by_country') }}
                                </a>
                                <a href="{{ route('admin.analytics.stores.featured') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.stores.featured') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('featured_stores') }}
                                </a>
                                <a href="{{ route('admin.analytics.stores.by-followers') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.stores.by-followers') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('stores_by_followers') }}
                                </a>
                                <a href="{{ route('admin.analytics.stores.by-offers-count') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.stores.by-offers-count') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('stores_by_offers_count') }}
                                </a>
                                <a href="{{ route('admin.analytics.stores.performance') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.stores.performance') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('store_performance_report') }}
                                </a>
                            </div>
                        </div>

                        <!-- Users Analytics -->
                        <div x-data="{ usersOpen: {{ request()->routeIs('admin.analytics.users.*') ? 'true' : 'false' }} }">
                            <button @click="usersOpen = !usersOpen"
                                class="w-full flex items-center justify-between px-3 py-2 rounded-lg text-sm transition-all"
                                style="color: var(--color-text-secondary);"
                                onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
                                onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'">
                                <span>{{ admin_trans('users_analytics') }}</span>
                                <i data-lucide="chevron-down" class="w-3 h-3 transition-transform" :class="usersOpen ? 'rotate-180' : ''"></i>
                            </button>
                            <div x-show="usersOpen" x-cloak x-collapse class="ml-4 mt-1 space-y-1">
                                <a href="{{ route('admin.analytics.users.by-role') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.users.by-role') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('users_by_role') }}
                                </a>
                                <a href="{{ route('admin.analytics.users.by-country') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.users.by-country') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('users_by_country') }}
                                </a>
                                <a href="{{ route('admin.analytics.users.by-language') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.users.by-language') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('users_by_language') }}
                                </a>
                                <a href="{{ route('admin.analytics.users.growth-chart') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.users.growth-chart') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('user_growth_chart') }}
                                </a>
                                <a href="{{ route('admin.analytics.users.active') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.users.active') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('active_users') }}
                                </a>
                                <a href="{{ route('admin.analytics.users.banned') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.users.banned') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('banned_users') }}
                                </a>
                                <a href="{{ route('admin.analytics.users.guests') }}" class="block px-3 py-1.5 rounded-lg text-sm transition-all {{ request()->routeIs('admin.analytics.users.guests') ? 'active-submenu-item' : 'submenu-item' }}">
                                    {{ admin_trans('guest_users') }}
                                </a>
                            </div>
                        </div>

                    </div>
                </div>

                <!-- RESOURCES Section -->
                <div>
                    <h3 x-show="$store.sidebar.open" x-cloak
                        class="px-3 mb-2 text-xs font-bold uppercase tracking-wider"
                        style="color: var(--color-text-tertiary);">
                        {{ admin_trans('resources') }}
                    </h3>

                    <div class="space-y-1">
                        <!-- Users -->
                        <a href="{{ route('admin.users.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.users.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.users.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
                            onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="users" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('users') }}</span>
                        </a>

                        <!-- Subscriptions -->
                        <a href="{{ route('admin.subscriptions.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.subscriptions.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.subscriptions.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
                            onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="user-check" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('subscriptions') }}</span>
                        </a>

                        <!-- Categories -->
                        <a href="{{ route('admin.categories.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.categories.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.categories.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="layout-grid" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('categories') }}</span>
                        </a>


                        <!-- Countries -->
                        <a href="{{ route('admin.countries.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.countries.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.countries.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="globe" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('countries') }}</span>
                        </a>

                        <!-- Languages -->
                        <a href="{{ route('admin.languages.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.languages.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.languages.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
    onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="languages" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('languages') }}</span>
                        </a>

                        <!-- Locales -->
                        <a href="{{ route('admin.locales.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.locales.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.locales.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="globe-2" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('locales') }}</span>
                        </a>


                        <!-- Pages -->
                        <a href="{{ route('admin.pages.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.pages.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.pages.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="file-text" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('pages') }}</span>
                        </a>

                        <!-- Carousels -->
                        <a href="{{ route('admin.carousels.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.carousels.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.carousels.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
        onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="images" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('carousels') }}</span>
                        </a>

                        <!-- Media Library -->
                        <a href="{{ route('admin.media.index') }}"
                            class="flex items-center gap-3 px-3 py-2.5 rounded-xl {{ request()->routeIs('admin.media.*') ? 'active-menu-item' : 'menu-item' }} transition-all"
                            @if (!request()->routeIs('admin.media.*')) onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
   onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-secondary)'" @endif>
                            <i data-lucide="image" class="w-5 h-5 flex-shrink-0"></i>
                            <span x-show="$store.sidebar.open" x-cloak
                                class="font-medium">{{ admin_trans('media_library') }}</span>
                        </a>
                    </div>
                </div>

            </div>
        </nav>

    </div>
</aside>
