<nav class="h-16 border-b-2 flex items-center px-4 sm:px-6" style="background: var(--color-bg-primary); border-color: var(--color-border);">
    
    <!-- Left Side -->
    <div class="flex items-center gap-3 flex-1">
        <!-- Mobile Menu Button -->
        <button 
            @click="$store.sidebar.toggle()"
            class="lg:hidden p-2 rounded-xl transition-all flex-shrink-0"
            style="background: var(--color-bg-secondary);"
            onmouseover="this.style.background='var(--color-primary-light)'; this.querySelector('i').style.color='var(--color-primary)'"
            onmouseout="this.style.background='var(--color-bg-secondary)'; this.querySelector('i').style.color='var(--color-text-primary)'"
        >
            <i data-lucide="menu" class="w-6 h-6 transition-colors" style="color: var(--color-text-primary);"></i>
        </button>

        <!-- Page Title -->
        <h1 class="text-lg sm:text-xl font-bold truncate" style="color: var(--color-text-primary);">
            @yield('page-title', admin_trans('dashboard'))
        </h1>
        
    </div>

    <!-- Center - Country Filter -->
    <div class="hidden md:flex items-center justify-center flex-1">

    </div>

    <!-- Right Side -->
    <div class="flex items-center gap-2 sm:gap-3 flex-shrink-0">

            <div x-data="countryFilter()" class="relative">
            <!-- Country Filter Button -->
            <button 
                @click="open = !open"
                class="flex items-center gap-4 px-4 py-2 rounded-xl transition-all min-w-[180px]"
                style="background: var(--color-bg-secondary); border: 1px solid var(--color-border);"
                onmouseover="this.style.borderColor='var(--color-primary)'"
                onmouseout="this.style.borderColor='var(--color-border)'"
            >
                <i data-lucide="globe" class="w-4 h-4 text-primary"></i>
                <span class="text-sm font-medium text-primary" x-text="selectedCountry ? selectedCountry.name : '{{ admin_trans('select_country') }}'"></span>
                <i data-lucide="chevron-down" class="w-4 h-4 text-tertiary transition-transform" :class="open ? 'rotate-180' : ''"></i>
            </button>

            <!-- Dropdown -->
            <div
                x-show="open"
                @click.away="open = false"
                x-cloak
                x-transition
                class="absolute top-full mt-2 left-0 right-0 rounded-xl shadow-xl  py-2 z-50 w-64 max-h-64 overflow-y-auto"
                style="background: var(--color-bg-primary); border-color: var(--color-border);"
            >
                <!-- Clear Filter Option -->
                <button 
                    @click="clearFilter()"
                    class="w-full flex items-center gap-3 px-4 py-2.5 text-sm hover:bg-primary-light transition-colors"
                >
                    <i data-lucide="x-circle" class="w-4 h-4 text-red-500"></i>
                    <span class="text-red-500 font-medium">{{ admin_trans('clear_filter') }}</span>
                </button>
                
                <div class="border-t my-1" style="border-color: var(--color-border);"></div>

                <!-- Countries List -->
                <template x-for="country in countries" :key="country.id">
                    <button 
                        @click="selectCountry(country)"
                        class="w-full flex items-center gap-3 px-4 py-2.5 text-sm hover:bg-primary-light transition-colors"
                        :class="selectedCountry && selectedCountry.id === country.id ? 'bg-primary-light text-primary' : 'text-secondary'"
                    >
                        <span x-text="country.flag_emoji" class="text-lg w-6 text-center"></span>
                        <span x-text="country.name" class="flex-1 text-left"></span>
                        <span x-text="country.code" class="text-xs text-tertiary uppercase"></span>
                        
                        <!-- Selected Indicator -->
                        <i x-show="selectedCountry && selectedCountry.id === country.id" 
                           data-lucide="check" class="w-4 h-4 text-primary"></i>
                    </button>
                </template>
                
                <!-- Loading State -->
                <div x-show="loading" class="px-4 py-3 text-center">
                    <div class="flex items-center justify-center gap-2">
                        <div class="w-4 h-4 border-2 border-primary border-t-transparent rounded-full animate-spin"></div>
                        <span class="text-sm text-tertiary">{{ admin_trans('loading') }}...</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Mobile Country Filter -->
        <div x-data="countryFilter()" class="md:hidden relative">
            <button 
                @click="open = !open"
                class="p-2 rounded-xl transition-all"
                style="background: var(--color-bg-secondary);"
                onmouseover="this.style.background='var(--color-primary-light)'"
                onmouseout="this.style.background='var(--color-bg-secondary)'"
            >
            </button>

            <!-- Mobile Dropdown -->
            <div
                x-show="open"
                @click.away="open = false"
                x-cloak
                x-transition
                class="absolute top-full mt-2 right-0 w-64 rounded-xl shadow-xl border py-2 z-50 max-h-64 overflow-y-auto"
                style="background: var(--color-bg-primary); border-color: var(--color-border);"
            >
                <!-- Same content as desktop dropdown -->
                <button 
                    @click="clearFilter()"
                    class="w-full flex items-center gap-3 px-4 py-2.5 text-sm hover:bg-primary-light transition-colors"
                >
                    <i data-lucide="x-circle" class="w-4 h-4 text-red-500"></i>
                    <span class="text-red-500 font-medium">{{ admin_trans('clear_filter') }}</span>
                </button>
                
                <div class="border-t my-1" style="border-color: var(--color-border);"></div>

                <template x-for="country in countries" :key="country.id">
                    <button 
                        @click="selectCountry(country)"
                        class="w-full flex items-center gap-3 px-4 py-2.5 text-sm hover:bg-primary-light transition-colors"
                        :class="selectedCountry && selectedCountry.id === country.id ? 'bg-primary-light text-primary' : 'text-secondary'"
                    >
                        <span x-text="country.flag_emoji" class="text-lg"></span>
                        <span x-text="country.name" class="flex-1 text-left"></span>
                        <i x-show="selectedCountry && selectedCountry.id === country.id" 
                           data-lucide="check" class="w-4 h-4 text-primary"></i>
                    </button>
                </template>
            </div>
        </div>

        <!-- Theme Toggle -->
        <button 
            @click="$store.theme.toggle()"
            class="p-2 rounded-xl transition-all flex-shrink-0"
            style="background: var(--color-bg-secondary);"
            onmouseover="this.style.background='var(--color-primary-light)'; this.querySelector('i').style.color='var(--color-primary)'"
            onmouseout="this.style.background='var(--color-bg-secondary)'; this.querySelector('i').style.color='var(--color-text-primary)'"
        >
            <i x-show="$store.theme.mode === 'light'" data-lucide="sun" class="w-5 h-5" style="color: var(--color-text-primary);"></i>
            <i x-show="$store.theme.mode === 'dark'" x-cloak data-lucide="moon" class="w-5 h-5" style="color: var(--color-text-primary);"></i>
        </button>

        <!-- Language Toggle -->
        <a 
            href="{{ route('admin.locale', admin_locale() === 'ar' ? 'en' : 'ar') }}"
            class="hidden sm:flex px-3 py-2 rounded-xl transition-all items-center gap-2 font-medium flex-shrink-0"
            style="background: var(--color-bg-secondary); color: var(--color-text-primary); text-decoration: none;"
            onmouseover="this.style.background='var(--color-secondary-light)'; this.style.color='var(--color-secondary)'"
            onmouseout="this.style.background='var(--color-bg-secondary)'; this.style.color='var(--color-text-primary)'"
        >
            <i data-lucide="languages" class="w-5 h-5"></i>
            <span class="text-sm">{{ admin_locale() === 'ar' ? 'EN' : 'ع' }}</span>
        </a>

      <!-- Notifications -->
        <a href="{{ route('admin.notifications.index') }}"
           class="hidden sm:block p-2 rounded-xl transition-all relative flex-shrink-0"
           style="background: var(--color-bg-secondary);"
           onmouseover="this.style.background='var(--color-primary-light)'; this.querySelector('i').style.color='var(--color-primary)'"
           onmouseout="this.style.background='var(--color-bg-secondary)'; this.querySelector('i').style.color='var(--color-text-primary)'"
        >
            <i data-lucide="bell" class="w-5 h-5 transition-colors" style="color: var(--color-text-primary);"></i>
            <!-- Notification Badge -->
            @php
                $pendingNotifications = \App\Models\Notification::where('status', 'pending')->count();
            @endphp
            @if($pendingNotifications > 0)
                <span class="absolute top-1 {{ is_rtl() ? 'left-1' : 'right-1' }} min-w-[16px] h-4 text-xs rounded-full flex items-center justify-center text-white font-medium px-1" 
                      style="background: var(--color-danger);">
                    {{ $pendingNotifications > 99 ? '99+' : $pendingNotifications }}
                </span>
            @endif
        </a>

        <!-- User Menu -->
        <div x-data="{ open: false }" class="relative flex-shrink-0">
            <button 
                @click="open = !open"
                class="flex items-center gap-2 px-2 py-1.5 rounded-xl transition-all"
                style="background: var(--color-bg-secondary);"
                onmouseover="this.style.background='var(--color-primary-light)'"
                onmouseout="this.style.background='var(--color-bg-secondary)'"
            >
                <div class="w-8 h-8 rounded-xl flex items-center justify-center text-white font-bold gradient-primary text-sm">
                    {{ substr(auth()->user()->name, 0, 1) }}
                </div>
                <i data-lucide="chevron-down" class="w-4 h-4" style="color: var(--color-text-secondary);"></i>
            </button>

            <!-- Dropdown -->
            <div 
                x-show="open" 
                @click.away="open = false"
                x-cloak
                x-transition
                class="absolute {{ is_rtl() ? 'left-0' : 'right-0' }} mt-2 w-48 rounded-xl shadow-xl py-2 z-50"
                style="background: var(--color-bg-primary); border: 1px solid var(--color-border);"
            >
                <!-- User Info -->
                <div class="px-4 py-3 border-b-2" style="border-color: var(--color-border);">
                    <p class="text-sm font-semibold truncate" style="color: var(--color-text-primary);">{{ auth()->user()->name }}</p>
                    <p class="text-xs truncate" style="color: var(--color-text-tertiary);">{{ auth()->user()->email }}</p>
                </div>

                <!-- Profile -->
                <a 
                    href="{{ route('admin.profile.show') }}" 
                    class="flex items-center gap-3 px-4 py-2.5 transition-colors font-medium"
                    style="color: var(--color-text-primary); text-decoration: none;"
                    onmouseover="this.style.background='var(--color-primary-light)'; this.style.color='var(--color-primary)'"
                    onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-primary)'"
                >
                    <i data-lucide="user-circle" class="w-5 h-5"></i>
                    <span>{{ admin_trans('profile') }}</span>
                </a>
                
                <!-- Language in dropdown for mobile -->
                <a 
                    href="{{ route('admin.locale', admin_locale() === 'ar' ? 'en' : 'ar') }}"
                    class="sm:hidden flex items-center gap-3 px-4 py-2.5 transition-colors font-medium"
                    style="color: var(--color-text-primary); text-decoration: none;"
                    onmouseover="this.style.background='var(--color-secondary-light)'; this.style.color='var(--color-secondary)'"
                    onmouseout="this.style.background='transparent'; this.style.color='var(--color-text-primary)'"
                >
                    <i data-lucide="languages" class="w-5 h-5"></i>
                    <span>{{ admin_locale() === 'ar' ? 'English' : 'العربية' }}</span>
                </a>
                
                <div class="my-1 border-t" style="border-color: var(--color-border);"></div>
                
                <!-- Logout -->
                <form method="POST" action="{{ route('admin.logout') }}">
                    @csrf
                    <button 
                        type="submit" 
                        class="w-full flex items-center gap-3 px-4 py-2.5 transition-colors font-medium text-red-600"
                        onmouseover="this.style.background='rgba(239, 68, 68, 0.1)'"
                        onmouseout="this.style.background='transparent'"
                    >
                        <i data-lucide="log-out" class="w-5 h-5"></i>
                        <span>{{ admin_trans('logout') }}</span>
                    </button>
                </form>
            </div>
        </div>

    </div>

</nav>

<script>
// Country Filter Alpine.js Component - Optimized Version
function countryFilter() {
    return {
        open: false,
        loading: false,
        countries: [],
        selectedCountry: null,

        async init() {
            // Load data once - no duplicate calls
            await this.loadData();
        },

        async loadData() {
            // Single API call that gets both countries and current filter
            try {
                this.loading = true;
                const response = await fetch('/admin/country-filter');
                const data = await response.json();
                
                if (data.success) {
                    this.countries = data.available_countries;
                    this.selectedCountry = data.country;
                }
            } catch (error) {
                console.error('Failed to load country data:', error);
            } finally {
                this.loading = false;
            }
        },

        async selectCountry(country) {
            try {
                const response = await fetch('/admin/country-filter', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({ country_id: country.id })
                });

                const data = await response.json();
                
                if (data.success) {
                    this.selectedCountry = country;
                    this.open = false;
                    
                    // Show success message
                    if (window.toast) {
                        const message = '{{ admin_trans("country_selected") }}'.replace(':country', country.name);
                        toast.success(message);
                    }

                    // Trigger global event for other components
                    window.dispatchEvent(new CustomEvent('country-filter-changed', {
                        detail: { country }
                    }));
                }
            } catch (error) {
                console.error('Failed to set country filter:', error);
                if (window.toast) {
                    toast.error('{{ admin_trans("error_setting_country_filter") }}');
                }
            }
        },

        async clearFilter() {
            try {
                const response = await fetch('/admin/country-filter', {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    }
                });

                if (response.ok) {
                    this.selectedCountry = null;
                    this.open = false;

                    if (window.toast) {
                        toast.info('{{ admin_trans("country_filter_removed") }}');
                    }

                    // Trigger global event
                    window.dispatchEvent(new CustomEvent('country-filter-changed', {
                        detail: { country: null }
                    }));
                }
            } catch (error) {
                console.error('Failed to clear country filter:', error);
                if (window.toast) {
                    toast.error('{{ admin_trans("error_removing_country_filter") }}');
                }
            }
        }
    }
}
</script>