<!DOCTYPE html>
<html lang="{{ admin_locale() }}" dir="{{ is_rtl() ? 'rtl' : 'ltr' }}" x-data x-init="$store.theme.init()">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', admin_trans('dashboard')) - {{ admin_trans('admin_panel') }}</title>
    
    <script src="https://unpkg.com/lucide@latest"></script>

    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="antialiased" style="background: var(--color-bg-secondary);">

    <div class="flex h-screen overflow-hidden">

        <!-- Sidebar -->
        @include('admin.layouts.sidebar')

        <!-- Main Content Area -->
        <div class="flex-1 flex flex-col overflow-hidden">

            <!-- Top Navbar -->
            @include('admin.layouts.navbar')

            <!-- Page Content -->
            <main class="flex-1 overflow-y-auto p-6">
                @yield('content')
            </main>

        </div>

    </div>

    <!-- Toast Container (auto-injected by JS) -->

    <style>
        [x-cloak] {
            display: none !important;
        }
        .border-b-2 {
            border-bottom-width: 1px !important;
            border-color: rgba(34, 51, 34, 0.16) !important;
        }

        .border-b {
            border-bottom-width: 1px !important;
            border-color: rgba(34, 51, 34, 0.27) !important;
        }
    </style>

    <!-- ✅ ضيف السطر ده هنا قبل الـ script -->
    @stack('scripts')

</body>

<script>
    // Initialize Lucide icons
    lucide.createIcons();

    // Handle flash messages
    document.addEventListener('DOMContentLoaded', () => {
        @if(session('toast'))
            const type = '{{ session('toast.type') }}';
            const message = '{{ session('toast.message') }}';
            const title = '{{ session('toast.title') }}';
            
            if (window.toast && window.toast[type]) {
                window.toast[type](message, title);
            }
        @endif
    });
</script>

</html>