@extends('admin.layouts.app')

@section('title', 'Design System')
@section('page-title', 'Design System Components')

@section('content')

<x-tabs defaultTab="buttons" class="space-y-6">
    <!-- Tab Navigation -->
    <div class="flex flex-wrap gap-1 border-b-2" style="border-color: var(--color-border);">
        <x-tab-button tab="buttons" icon="mouse-pointer-2">Buttons</x-tab-button>
        <x-tab-button tab="forms" icon="edit-3">Forms</x-tab-button>
        <x-tab-button tab="data" icon="table">Data Tables</x-tab-button>
        <x-tab-button tab="feedback" icon="message-circle">Feedback</x-tab-button>
        <x-tab-button tab="navigation" icon="menu">Navigation</x-tab-button>
        <x-tab-button tab="upload" icon="upload">File Upload</x-tab-button>
        <x-tab-button tab="layout" icon="layout">Layout</x-tab-button>
        <x-tab-button tab="modals" icon="layers">Modals</x-tab-button>
    </div>

    <!-- Buttons Tab -->
    <x-tab-content tab="buttons">
        <div class="space-y-8">
            <!-- Button Variants -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Button Variants</h3>
                <div class="flex flex-wrap gap-3 mb-4">
                    <x-button variant="primary">Primary Button</x-button>
                    <x-button variant="secondary">Secondary Button</x-button>
                    <x-button variant="outline">Outline Button</x-button>
                    <x-button variant="ghost">Ghost Button</x-button>
                    <x-button variant="danger">Danger Button</x-button>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-button variant="primary"&gt;Primary Button&lt;/x-button&gt;<br>
                        &lt;x-button variant="secondary"&gt;Secondary Button&lt;/x-button&gt;<br>
                        &lt;x-button variant="outline"&gt;Outline Button&lt;/x-button&gt;
                    </code>
                </div>
            </div>

            <!-- Button Sizes -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Button Sizes</h3>
                <div class="flex flex-wrap items-center gap-3 mb-4">
                    <x-button size="sm">Small</x-button>
                    <x-button>Medium (Default)</x-button>
                    <x-button size="lg">Large</x-button>
                    <x-button size="icon" icon="heart" variant="primary"></x-button>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-button size="sm"&gt;Small&lt;/x-button&gt;<br>
                        &lt;x-button&gt;Medium&lt;/x-button&gt;<br>
                        &lt;x-button size="lg"&gt;Large&lt;/x-button&gt;<br>
                        &lt;x-button size="icon" icon="heart"&gt;&lt;/x-button&gt;
                    </code>
                </div>
            </div>

            <!-- Buttons with Icons -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Buttons with Icons</h3>
                <div class="flex flex-wrap gap-3 mb-4">
                    <x-button icon="plus">Add New</x-button>
                    <x-button variant="secondary" icon="download">Download</x-button>
                    <x-button variant="outline" icon="settings">Settings</x-button>
                    <x-button variant="danger" icon="trash-2">Delete</x-button>
                    <x-button icon="arrow-right" iconPosition="right">Next</x-button>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-button icon="plus"&gt;Add New&lt;/x-button&gt;<br>
                        &lt;x-button icon="arrow-right" iconPosition="right"&gt;Next&lt;/x-button&gt;
                    </code>
                </div>
            </div>

            <!-- Button States -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Button States</h3>
                <div class="flex flex-wrap gap-3 mb-4">
                    <x-button :loading="true">Loading...</x-button>
                    <x-button :disabled="true">Disabled</x-button>
                    <x-button href="#">Link Button</x-button>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-button :loading="true"&gt;Loading...&lt;/x-button&gt;<br>
                        &lt;x-button :disabled="true"&gt;Disabled&lt;/x-button&gt;<br>
                        &lt;x-button href="#"&gt;Link Button&lt;/x-button&gt;
                    </code>
                </div>
            </div>
        </div>
    </x-tab-content>

    <!-- Forms Tab -->
    <x-tab-content tab="forms">
        <div class="space-y-8">
            <!-- Text Inputs -->
            <div class="card">
                <h3 class="text-xl font-bold mb-6 text-primary">Text Inputs</h3>
                <div class="grid md:grid-cols-2 gap-6 mb-4">
                    <x-input 
                        label="Email Address"
                        type="email"
                        placeholder="admin@example.com"
                        icon="mail"
                        :required="true"
                    />

                    <x-input 
                        label="Phone Number"
                        type="tel"
                        placeholder="+1 (555) 000-0000"
                        icon="phone"
                    />

                    <x-input 
                        label="Password"
                        type="password"
                        placeholder="••••••••"
                        icon="lock"
                        hint="Must be at least 8 characters"
                    />

                    <x-input 
                        label="With Error"
                        error="This field is required"
                        icon="alert-circle"
                    />
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-input label="Email" type="email" icon="mail" :required="true" /&gt;<br>
                        &lt;x-input label="Phone" type="tel" placeholder="+1 (555) 000-0000" /&gt;<br>
                        &lt;x-input label="Error Field" error="This field is required" /&gt;
                    </code>
                </div>
            </div>

            <!-- Select Dropdown -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Select Dropdown</h3>
                <div class="max-w-md mb-4">
                    <x-select 
                        label="Country"
                        placeholder="Select a country"
                        :required="true"
                    >
                        <option value="us">United States</option>
                        <option value="uk">United Kingdom</option>
                        <option value="ca">Canada</option>
                        <option value="au">Australia</option>
                    </x-select>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-select label="Country" placeholder="Select country"&gt;<br>
                        &nbsp;&nbsp;&lt;option value="us"&gt;United States&lt;/option&gt;<br>
                        &nbsp;&nbsp;&lt;option value="uk"&gt;United Kingdom&lt;/option&gt;<br>
                        &lt;/x-select&gt;
                    </code>
                </div>
            </div>

            <!-- Textarea -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Textarea</h3>
                <div class="max-w-md mb-4">
                    <x-textarea 
                        label="Description"
                        placeholder="Enter description here..."
                        hint="Maximum 500 characters"
                        :rows="4"
                    />
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-textarea label="Description" :rows="4" hint="Max 500 chars" /&gt;
                    </code>
                </div>
            </div>

            <!-- Search Input -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Search Input</h3>
                <div class="max-w-md mb-4">
                    <x-search-input 
                        placeholder="Search anything..."
                    />
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-search-input placeholder="Search anything..." /&gt;
                    </code>
                </div>
            </div>
            <!-- Toggle Switches -->
<div class="card">
    <h3 class="text-xl font-bold mb-4 text-primary">Toggle Switches</h3>
    
    <!-- Basic Usage -->
    <div class="space-y-4 mb-6">
        <h4 class="text-lg font-semibold text-primary">Basic Usage</h4>
        <div class="space-y-4">
            <x-toggle 
                name="enable_notifications" 
                label="Enable notifications"
                description="Get notified when something happens"
            />
            
            <x-toggle 
                name="auto_save" 
                label="Auto-save enabled"
                description="Automatically save your changes"
                :checked="true"
            />
            
            <x-toggle 
                name="premium_feature" 
                label="Premium feature (disabled)"
                description="Upgrade to access this feature"
                :disabled="true"
            />
        </div>
    </div>

    <!-- Different Sizes -->
    <div class="space-y-4 mb-6">
        <h4 class="text-lg font-semibold text-primary">Different Sizes</h4>
        <div class="space-y-4">
            <x-toggle 
                size="sm" 
                name="small_toggle"
                label="Small toggle"
                description="Compact size for tight spaces"
                :checked="true" 
            />
            
            <x-toggle 
                size="md" 
                name="medium_toggle"
                label="Medium toggle (default)"
                description="Standard size for most use cases"
                :checked="true" 
            />
            
            <x-toggle 
                size="lg" 
                name="large_toggle"
                label="Large toggle"
                description="Larger size for better accessibility"
                :checked="true" 
            />
        </div>
    </div>

    <!-- Color Variants -->
    <div class="space-y-4 mb-6">
        <h4 class="text-lg font-semibold text-primary">Color Variants</h4>
        <div class="space-y-4">
            <x-toggle 
                variant="primary" 
                name="primary_toggle"
                label="Primary toggle"
                :checked="true" 
            />
            
            <x-toggle 
                variant="secondary" 
                name="secondary_toggle"
                label="Secondary toggle"
                :checked="true" 
            />
            
            <x-toggle 
                variant="success" 
                name="success_toggle"
                label="Success toggle"
                :checked="true" 
            />
            
            <x-toggle 
                variant="warning" 
                name="warning_toggle"
                label="Warning toggle"
                :checked="true" 
            />
            
            <x-toggle 
                variant="danger" 
                name="danger_toggle"
                label="Danger toggle"
                :checked="true" 
            />
        </div>
    </div>

    <!-- Simple Toggles (No Labels) -->
    <div class="space-y-4 mb-4">
        <h4 class="text-lg font-semibold text-primary">Simple Toggles</h4>
        <div class="flex items-center gap-6">
            <x-toggle name="simple1" size="sm" />
            <x-toggle name="simple2" :checked="true" />
            <x-toggle name="simple3" size="lg" variant="success" :checked="true" />
        </div>
    </div>

    <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
        <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
        <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
            &lt;x-toggle name="notifications" label="Enable notifications" /&gt;<br>
            &lt;x-toggle name="auto_save" :checked="true" size="lg" /&gt;<br>
            &lt;x-toggle name="premium" variant="success" :disabled="true" /&gt;<br>
            &lt;x-toggle name="simple" /&gt; &lt;!-- Without label --&gt;
        </code>
    </div>
</div>
            
        </div>
    </x-tab-content>

    <!-- Data Tables Tab -->
    <x-tab-content tab="data">
        <div class="space-y-8">
            <!-- Data Table -->
            <div class="card">
                <h3 class="text-xl font-bold mb-6 text-primary">Data Table</h3>
                
                <x-data-table 
                    :headers="['name' => 'Name', 'email' => 'Email', 'status' => 'Status']"
                    :searchable="true"
                    :filterable="true"
                    :sortable="true">
                    
                    <tr class="hover:bg-primary-light transition-colors">
                        <td class="px-4 py-3 text-primary font-medium">John Doe</td>
                        <td class="px-4 py-3 text-secondary">john@example.com</td>
                        <td class="px-4 py-3">
                            <x-badge variant="success">Active</x-badge>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <x-action-dropdown>
                                <x-action-item icon="eye" href="#">View</x-action-item>
                                <x-action-item icon="edit-3" href="#">Edit</x-action-item>
                                <x-action-item icon="trash-2" variant="danger">Delete</x-action-item>
                            </x-action-dropdown>
                        </td>
                    </tr>
                    
                    <tr class="hover:bg-primary-light transition-colors">
                        <td class="px-4 py-3 text-primary font-medium">Jane Smith</td>
                        <td class="px-4 py-3 text-secondary">jane@example.com</td>
                        <td class="px-4 py-3">
                            <x-badge variant="warning">Pending</x-badge>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <x-action-dropdown>
                                <x-action-item icon="eye" href="#">View</x-action-item>
                                <x-action-item icon="edit-3" href="#">Edit</x-action-item>
                                <x-action-item icon="trash-2" variant="danger">Delete</x-action-item>
                            </x-action-dropdown>
                        </td>
                    </tr>
                </x-data-table>

                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-data-table :headers="['name' => 'Name', 'email' => 'Email']"&gt;<br>
                        &nbsp;&nbsp;&lt;tr&gt;<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;John Doe&lt;/td&gt;<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;john@example.com&lt;/td&gt;<br>
                        &nbsp;&nbsp;&lt;/tr&gt;<br>
                        &lt;/x-data-table&gt;
                    </code>
                </div>
            </div>

            <!-- Badges -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Badges</h3>
                <div class="flex flex-wrap gap-3 mb-4">
                    <x-badge variant="primary">Primary</x-badge>
                    <x-badge variant="secondary">Secondary</x-badge>
                    <x-badge variant="success" icon="check">Active</x-badge>
                    <x-badge variant="warning" icon="clock">Pending</x-badge>
                    <x-badge variant="danger" icon="x">Inactive</x-badge>
                    <x-badge variant="info" icon="info">Info</x-badge>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-badge variant="success" icon="check"&gt;Active&lt;/x-badge&gt;<br>
                        &lt;x-badge variant="warning"&gt;Pending&lt;/x-badge&gt;<br>
                        &lt;x-badge variant="danger" icon="x"&gt;Inactive&lt;/x-badge&gt;
                    </code>
                </div>
            </div>

            <!-- Action Dropdown -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Action Dropdown</h3>
                <div class="flex gap-4 mb-4">
                    <x-action-dropdown>
                        <x-action-item icon="eye" href="#">View</x-action-item>
                        <x-action-item icon="edit-3" href="#">Edit</x-action-item>
                        <x-action-item icon="copy" href="#">Duplicate</x-action-item>
                        <x-action-item icon="trash-2" variant="danger">Delete</x-action-item>
                    </x-action-dropdown>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-action-dropdown&gt;<br>
                        &nbsp;&nbsp;&lt;x-action-item icon="eye" href="#"&gt;View&lt;/x-action-item&gt;<br>
                        &nbsp;&nbsp;&lt;x-action-item icon="edit-3"&gt;Edit&lt;/x-action-item&gt;<br>
                        &nbsp;&nbsp;&lt;x-action-item icon="trash-2" variant="danger"&gt;Delete&lt;/x-action-item&gt;<br>
                        &lt;/x-action-dropdown&gt;
                    </code>
                </div>
            </div>

            <!-- Filter Dropdown -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Filter Dropdown</h3>
                <div class="flex gap-4 mb-4">
                    <x-filter-dropdown 
                        label="Status" 
                        :options="['active' => 'Active', 'inactive' => 'Inactive', 'pending' => 'Pending']" 
                    />
                    <x-filter-dropdown 
                        label="Type" 
                        :options="['user' => 'User', 'admin' => 'Admin']" 
                        :multiple="true"
                    />
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-filter-dropdown label="Status" :options="['active' => 'Active']" /&gt;<br>
                        &lt;x-filter-dropdown label="Type" :multiple="true" :options="[...]" /&gt;
                    </code>
                </div>
            </div>

            <!-- Empty State -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Empty State</h3>
                <x-empty-state 
                    icon="inbox"
                    title="No data found"
                    description="Get started by creating a new item"
                    actionText="Add New Item"
                    actionUrl="#"
                />
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-empty-state<br>
                        &nbsp;&nbsp;icon="inbox"<br>
                        &nbsp;&nbsp;title="No data found"<br>
                        &nbsp;&nbsp;description="Get started by creating a new item"<br>
                        &nbsp;&nbsp;actionText="Add New Item"<br>
                        &nbsp;&nbsp;actionUrl="#" /&gt;
                    </code>
                </div>
            </div>
        </div>
    </x-tab-content>

    <!-- Feedback Tab -->
    <x-tab-content tab="feedback">
        <div class="space-y-8">
            <!-- Toast Notifications -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Toast Notifications</h3>
                <div class="flex flex-wrap gap-3 mb-4">
                    <x-button 
                        variant="primary"
                        onclick="toast.success('Operation completed successfully!', 'Success')"
                    >
                        Success Toast
                    </x-button>

                    <x-button 
                        variant="danger"
                        onclick="toast.error('Something went wrong!', 'Error')"
                    >
                        Error Toast
                    </x-button>

                    <x-button 
                        variant="outline"
                        onclick="toast.warning('Please review your input', 'Warning')"
                    >
                        Warning Toast
                    </x-button>

                    <x-button 
                        variant="secondary"
                        onclick="toast.info('New update available', 'Information')"
                    >
                        Info Toast
                    </x-button>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2">Usage (JavaScript):</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        toast.success('Message', 'Title');<br>
                        toast.error('Message', 'Title');<br>
                        toast.warning('Message', 'Title');<br>
                        toast.info('Message', 'Title');
                    </code>
                </div>
            </div>

            <!-- Alert Boxes -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Alert Boxes</h3>
                <div class="space-y-4 mb-4">
                    <x-alert variant="success" title="Success!" :dismissible="true">
                        Data has been saved successfully
                    </x-alert>
                    
                    <x-alert variant="warning" title="Warning!" :dismissible="true">
                        Please review the entered data
                    </x-alert>
                    
                    <x-alert variant="danger" title="Error!" :dismissible="true">
                        An error occurred while processing
                    </x-alert>
                    
                    <x-alert variant="info" title="Information">
                        System maintenance scheduled for tonight
                    </x-alert>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-alert variant="success" title="Success!" :dismissible="true"&gt;<br>
                        &nbsp;&nbsp;Data has been saved successfully<br>
                        &lt;/x-alert&gt;
                    </code>
                </div>
            </div>

            <!-- Loading States -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Loading States</h3>
                <div class="flex flex-wrap gap-6 items-center mb-4">
                    <x-loading size="sm" text="Loading..." />
                    <x-loading size="md" text="Processing..." />
                    <x-loading size="lg" text="Please wait..." />
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-loading size="sm" text="Loading..." /&gt;<br>
                        &lt;x-loading size="md" text="Processing..." /&gt;<br>
                        &lt;x-loading size="lg" text="Please wait..." /&gt;
                    </code>
                </div>
            </div>
        </div>
    </x-tab-content>

    <!-- Navigation Tab -->
    <x-tab-content tab="navigation">
        <div class="space-y-8">
            <!-- Tabs -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Tabs Component</h3>
                <x-tabs defaultTab="tab1" class="mb-4">
                    <div class="flex gap-1 border-b-2 mb-4" style="border-color: var(--color-border);">
                        <x-tab-button tab="tab1" icon="home">Overview</x-tab-button>
                        <x-tab-button tab="tab2" icon="settings">Settings</x-tab-button>
                        <x-tab-button tab="tab3" icon="users">Users</x-tab-button>
                    </div>
                    
                    <x-tab-content tab="tab1">
                        <p class="text-secondary">Overview content goes here...</p>
                    </x-tab-content>
                    
                    <x-tab-content tab="tab2">
                        <p class="text-secondary">Settings content goes here...</p>
                    </x-tab-content>
                    
                    <x-tab-content tab="tab3">
                        <p class="text-secondary">Users content goes here...</p>
                    </x-tab-content>
                </x-tabs>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-tabs defaultTab="tab1"&gt;<br>
                        &nbsp;&nbsp;&lt;x-tab-button tab="tab1" icon="home"&gt;Overview&lt;/x-tab-button&gt;<br>
                        &nbsp;&nbsp;&lt;x-tab-content tab="tab1"&gt;Content here&lt;/x-tab-content&gt;<br>
                        &lt;/x-tabs&gt;
                    </code>
                </div>
            </div>

            <!-- Pagination -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Pagination</h3>
                <div class="mb-4">
                    {{-- Mock pagination for demo --}}
                    <div class="flex items-center justify-between">
                        <div class="text-sm text-tertiary">
                            Showing 1 to 10 of 100 results
                        </div>
                        
                        <nav class="flex items-center gap-1">
                            <span class="px-3 py-2 text-tertiary cursor-not-allowed">
                                <i data-lucide="chevron-left" class="w-4 h-4"></i>
                            </span>
                            <span class="px-3 py-2 rounded-lg text-white font-medium gradient-primary">1</span>
                            <a href="#" class="px-3 py-2 rounded-lg transition-colors hover:bg-primary-light text-primary">2</a>
                            <a href="#" class="px-3 py-2 rounded-lg transition-colors hover:bg-primary-light text-primary">3</a>
                            <span class="px-3 py-2 text-tertiary">...</span>
                            <a href="#" class="px-3 py-2 rounded-lg transition-colors hover:bg-primary-light text-primary">10</a>
                            <a href="#" class="px-3 py-2 rounded-lg transition-colors hover:bg-primary-light text-primary">
                                <i data-lucide="chevron-right" class="w-4 h-4"></i>
                            </a>
                        </nav>
                    </div>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-pagination :paginator="$items" /&gt;<br>
                        &lt;x-pagination :paginator="$items" :simple="true" /&gt;
                    </code>
                </div>
            </div>
        </div>
    </x-tab-content>

    <!-- File Upload Tab -->
    <x-tab-content tab="upload">
        <div class="space-y-8">
            <!-- File Upload -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">File Upload</h3>
                <div class="max-w-lg mb-4">
                    <x-file-upload 
                        label="Upload Files"
                        name="files"
                        accept="image/*,.pdf,.doc,.docx"
                        :multiple="true"
                        maxSize="10MB"
                        :preview="true"
                    />
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-file-upload<br>
                        &nbsp;&nbsp;label="Upload Files"<br>
                        &nbsp;&nbsp;name="files"<br>
                        &nbsp;&nbsp;accept="image/*,.pdf"<br>
                        &nbsp;&nbsp;:multiple="true"<br>
                        &nbsp;&nbsp;maxSize="10MB"<br>
                        &nbsp;&nbsp;:preview="true" /&gt;
                    </code>
                </div>
            </div>
        </div>
    </x-tab-content>

 <!-- Layout Tab -->
    <x-tab-content tab="layout">
        <div class="space-y-8">
            <!-- Cards -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Cards</h3>
                <div class="grid md:grid-cols-3 gap-6 mb-4">
                    <!-- Basic Card -->
                    <div class="card">
                        <h4 class="font-semibold text-primary mb-2">Basic Card</h4>
                        <p class="text-secondary text-sm">This is a basic card with some content inside.</p>
                    </div>
                    
                    <!-- Card with Header -->
                    <x-card title="Card Title" subtitle="Card subtitle" icon="star">
                        <p class="text-secondary text-sm">Card content goes here with a nice header section.</p>
                    </x-card>
                    
                    <!-- Card with Actions -->
                    <x-card title="With Actions" icon="settings">
                        <x-slot name="actions">
                            <x-button size="sm" variant="outline">Edit</x-button>
                        </x-slot>
                        <p class="text-secondary text-sm">This card has action buttons in the header.</p>
                    </x-card>
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;div class="card"&gt;Content&lt;/div&gt;<br>
                        &lt;x-card title="Title" subtitle="Subtitle" icon="star"&gt;Content&lt;/x-card&gt;<br>
                        &lt;x-card title="With Actions"&gt;<br>
                        &nbsp;&nbsp;&lt;x-slot name="actions"&gt;...&lt;/x-slot&gt;<br>
                        &nbsp;&nbsp;Content<br>
                        &lt;/x-card&gt;
                    </code>
                </div>
            </div>

            <!-- Stat Cards -->
            <div class="card">
                <h3 class="text-xl font-bold mb-6 text-primary">Statistics Cards</h3>
                <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6 mb-4">
                    <x-stat-card 
                        title="Total Users"
                        value="2,543"
                        icon="users"
                        gradient="primary"
                        trend="vs last month"
                        trendDirection="up"
                        trendValue="12%"
                    />
                    
                    <x-stat-card 
                        title="Revenue"
                        value="$45,231"
                        icon="dollar-sign"
                        gradient="success"
                        trend="vs last month"
                        trendDirection="up"
                        trendValue="8%"
                    />
                    
                    <x-stat-card 
                        title="Active Sessions"
                        value="892"
                        icon="activity"
                        gradient="secondary"
                        trend="vs last month"
                        trendDirection="down"
                        trendValue="4%"
                    />
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-stat-card<br>
                        &nbsp;&nbsp;title="Total Users"<br>
                        &nbsp;&nbsp;value="2,543"<br>
                        &nbsp;&nbsp;icon="users"<br>
                        &nbsp;&nbsp;gradient="primary"<br>
                        &nbsp;&nbsp;trend="vs last month"<br>
                        &nbsp;&nbsp;trendDirection="up"<br>
                        &nbsp;&nbsp;trendValue="12%" /&gt;
                    </code>
                </div>
            </div>

            <!-- Activity Items -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Activity Items</h3>
                <div class="space-y-3 mb-4">
                    <x-activity-item 
                        icon="user-plus"
                        iconColor="primary"
                        title="New user registered"
                        description="John Doe joined the platform"
                        time="5 minutes ago"
                    />
                    
                    <x-activity-item 
                        icon="tag"
                        iconColor="success"
                        title="New offer added"
                        description="50% discount on electronics"
                        time="15 minutes ago"
                    />
                    
                    <x-activity-item 
                        icon="check-circle"
                        iconColor="purple"
                        title="Store verified"
                        description="Tech Store has been verified"
                        time="1 hour ago"
                    />
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-activity-item<br>
                        &nbsp;&nbsp;icon="user-plus"<br>
                        &nbsp;&nbsp;iconColor="primary"<br>
                        &nbsp;&nbsp;title="New user registered"<br>
                        &nbsp;&nbsp;description="John Doe joined"<br>
                        &nbsp;&nbsp;time="5 minutes ago" /&gt;
                    </code>
                </div>
            </div>

<!-- Enhanced Table Component -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Enhanced Table Component</h3>
                <x-enhanced-table 
                    :headers="[
                        'name' => ['text' => 'Name', 'sortable' => true, 'align' => 'left'],
                        'email' => ['text' => 'Email', 'width' => '250px', 'align' => 'left'],
                        'status' => ['text' => 'Status', 'align' => 'center', 'width' => '120px'],
                        'actions' => ['text' => 'Actions', 'align' => 'center', 'width' => '100px']
                    ]"
                    :responsive="true"
                    :striped="true"
                    class="mb-4"
                >
                    <tr class="hover:bg-primary-light transition-colors">
                        <td class="px-4 py-3 text-primary font-medium">John Doe</td>
                        <td class="px-4 py-3 text-secondary">john@example.com</td>
                        <td class="px-4 py-3 text-center">
                            <x-badge variant="success">Active</x-badge>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <x-button size="sm" variant="outline" icon="eye">View</x-button>
                        </td>
                    </tr>
                    <tr class="hover:bg-primary-light transition-colors">
                        <td class="px-4 py-3 text-primary font-medium">Jane Smith</td>
                        <td class="px-4 py-3 text-secondary">jane@example.com</td>
                        <td class="px-4 py-3 text-center">
                            <x-badge variant="warning">Pending</x-badge>
                        </td>
                        <td class="px-4 py-3 text-center">
                            <x-button size="sm" variant="outline" icon="eye">View</x-button>
                        </td>
                    </tr>
                </x-enhanced-table>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-enhanced-table<br>
                        &nbsp;&nbsp;:headers="[<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;'name' =&gt; ['text' =&gt; 'Name', 'sortable' =&gt; true],<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;'email' =&gt; ['text' =&gt; 'Email', 'width' =&gt; '250px'],<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;'status' =&gt; ['text' =&gt; 'Status', 'align' =&gt; 'center']<br>
                        &nbsp;&nbsp;]"<br>
                        &nbsp;&nbsp;:responsive="true"<br>
                        &nbsp;&nbsp;:striped="true"&gt;<br>
                        &nbsp;&nbsp;&lt;tr&gt;<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;John Doe&lt;/td&gt;<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;john@example.com&lt;/td&gt;<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&lt;td&gt;&lt;x-badge variant="success"&gt;Active&lt;/x-badge&gt;&lt;/td&gt;<br>
                        &nbsp;&nbsp;&lt;/tr&gt;<br>
                        &lt;/x-enhanced-table&gt;
                    </code>
                </div>
            </div>
            <!-- Sidebar Item -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Sidebar Navigation Items</h3>
                <div class="max-w-xs space-y-2 mb-4" style="background: var(--color-bg-primary); border: 1px solid var(--color-border); border-radius: 12px; padding: 1rem;">
                    <x-sidebar-item 
                        href="#"
                        icon="home"
                        label="Dashboard"
                        :active="true"
                    />
                    <x-sidebar-item 
                        href="#"
                        icon="settings"
                        label="Settings"
                    />
                    <x-sidebar-item 
                        href="#"
                        icon="users"
                        label="Users"
                        badge="5"
                    />
                </div>
                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-sidebar-item<br>
                        &nbsp;&nbsp;href="#"<br>
                        &nbsp;&nbsp;icon="home"<br>
                        &nbsp;&nbsp;label="Dashboard"<br>
                        &nbsp;&nbsp;:active="true" /&gt;<br><br>
                        &lt;x-sidebar-item<br>
                        &nbsp;&nbsp;href="#"<br>
                        &nbsp;&nbsp;icon="users"<br>
                        &nbsp;&nbsp;label="Users"<br>
                        &nbsp;&nbsp;badge="5" /&gt;
                    </code>
                </div>
            </div>
        </div>
    </x-tab-content>

<!-- Modals & Overlays Tab -->
    <x-tab-content tab="modals">
        <div class="space-y-8">
            <!-- Basic Modal -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Modal Dialog</h3>
                <div class="mb-4">
                    <x-button @click="$dispatch('open-modal', 'demo-modal')">
                        Open Modal
                    </x-button>
                </div>
                
                <x-modal name="demo-modal" maxWidth="md">
                    <div class="p-6">
                        <div class="flex items-center justify-between mb-4">
                            <h3 class="text-xl font-bold text-primary">Modal Title</h3>
                            <button @click="$dispatch('close-modal', 'demo-modal')" 
                                    class="p-2 rounded-lg hover:bg-primary-light transition-colors">
                                <i data-lucide="x" class="w-5 h-5 text-tertiary"></i>
                            </button>
                        </div>
                        <p class="text-secondary mb-6">
                            This is a modal dialog. It can contain any content you want.
                        </p>
                        <div class="flex gap-3 justify-end">
                            <x-button variant="outline" @click="$dispatch('close-modal', 'demo-modal')">
                                Cancel
                            </x-button>
                            <x-button @click="$dispatch('close-modal', 'demo-modal')">
                                Confirm
                            </x-button>
                        </div>
                    </div>
                </x-modal>

                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-button @click="$dispatch('open-modal', 'my-modal')"&gt;Open&lt;/x-button&gt;<br><br>
                        &lt;x-modal name="my-modal" maxWidth="md"&gt;<br>
                        &nbsp;&nbsp;&lt;div class="p-6"&gt;<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&lt;h3&gt;Modal Title&lt;/h3&gt;<br>
                        &nbsp;&nbsp;&nbsp;&nbsp;&lt;p&gt;Content here&lt;/p&gt;<br>
                        &nbsp;&nbsp;&lt;/div&gt;<br>
                        &lt;/x-modal&gt;
                    </code>
                </div>
            </div>

            <!-- Confirm Modal -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Confirmation Modal</h3>
                <div class="mb-4">
                    <x-button variant="danger" @click="$dispatch('open-modal', 'confirm-demo')">
                        Delete Item
                    </x-button>
                </div>

                <x-confirm-modal 
                    name="confirm-demo"
                    title="Delete this item?"
                    message="This action cannot be undone. Are you sure you want to continue?"
                    confirmText="Yes, Delete"
                    cancelText="Cancel"
                    confirmVariant="danger"
                    icon="trash-2"
                    iconColor="danger"
                />

                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Usage:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        &lt;x-button @click="$dispatch('open-modal', 'confirm-delete')"&gt;Delete&lt;/x-button&gt;<br><br>
                        &lt;x-confirm-modal<br>
                        &nbsp;&nbsp;name="confirm-delete"<br>
                        &nbsp;&nbsp;title="Delete this item?"<br>
                        &nbsp;&nbsp;message="This action cannot be undone"<br>
                        &nbsp;&nbsp;confirmText="Yes, Delete"<br>
                        &nbsp;&nbsp;confirmVariant="danger"<br>
                        &nbsp;&nbsp;icon="trash-2" /&gt;
                    </code>
                </div>
            </div>

            <!-- Modal Sizes -->
            <div class="card">
                <h3 class="text-xl font-bold mb-4 text-primary">Modal Sizes</h3>
                <div class="flex flex-wrap gap-3 mb-4">
                    <x-button size="sm" @click="$dispatch('open-modal', 'modal-sm')">Small</x-button>
                    <x-button size="sm" @click="$dispatch('open-modal', 'modal-md')">Medium</x-button>
                    <x-button size="sm" @click="$dispatch('open-modal', 'modal-lg')">Large</x-button>
                    <x-button size="sm" @click="$dispatch('open-modal', 'modal-xl')">Extra Large</x-button>
                </div>

                <x-modal name="modal-sm" maxWidth="sm">
                    <div class="p-6">
                        <h3 class="text-lg font-bold mb-2 text-primary">Small Modal</h3>
                        <p class="text-sm text-secondary">This is a small modal (max-w-sm)</p>
                    </div>
                </x-modal>

                <x-modal name="modal-md" maxWidth="md">
                    <div class="p-6">
                        <h3 class="text-lg font-bold mb-2 text-primary">Medium Modal</h3>
                        <p class="text-sm text-secondary">This is a medium modal (max-w-md)</p>
                    </div>
                </x-modal>

                <x-modal name="modal-lg" maxWidth="lg">
                    <div class="p-6">
                        <h3 class="text-lg font-bold mb-2 text-primary">Large Modal</h3>
                        <p class="text-sm text-secondary">This is a large modal (max-w-lg)</p>
                    </div>
                </x-modal>

                <x-modal name="modal-xl" maxWidth="xl">
                    <div class="p-6">
                        <h3 class="text-lg font-bold mb-2 text-primary">Extra Large Modal</h3>
                        <p class="text-sm text-secondary">This is an extra large modal (max-w-xl)</p>
                    </div>
                </x-modal>

                <div class="p-4 rounded-lg" style="background: var(--color-bg-secondary); border: 1px solid var(--color-border-primary);">
                    <p class="text-sm font-medium mb-2 text-primary">Available Sizes:</p>
                   <code class="text-sm" style="color: var(--color-text-primary); font-family: 'Courier New', monospace;">
                        maxWidth="sm" → max-w-sm (384px)<br>
                        maxWidth="md" → max-w-md (448px)<br>
                        maxWidth="lg" → max-w-lg (512px)<br>
                        maxWidth="xl" → max-w-xl (576px)<br>
                        maxWidth="2xl" → max-w-2xl (672px)<br>
                        maxWidth="3xl" → max-w-3xl (768px)
                    </code>
                </div>
            </div>
        </div>
    </x-tab-content>

</x-tabs>

@endsection