@php
    $title = admin_trans('users_by_role');
    $icon = 'shield';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="shield" :title="admin_trans('no_data')" />
@else
    <x-enhanced-table
        :headers="['role' => ['text' => 'Role', 'align' => 'auto'], 'total' => ['text' => 'Total Users', 'align' => 'center']]"
        :responsive="true"
    >
        @foreach($data as $item)
        <tr>
            <x-table-cell type="text"><x-badge variant="{{ $item->role === 'admin' ? 'danger' : 'primary' }}">{{ ucfirst($item->role) }}</x-badge></x-table-cell>
            <x-table-cell type="center"><span class="text-lg font-bold text-primary">{{ number_format($item->total) }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
@endif
@endsection
