@php
    $title = admin_trans('users_by_country');
    $icon = 'globe';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="globe" :title="admin_trans('no_data')" />
@else
    <x-enhanced-table
        :headers="['country' => ['text' => 'Country', 'align' => 'auto'], 'total' => ['text' => 'Total Users', 'align' => 'center']]"
        :responsive="true"
    >
        @foreach($data as $item)
        <tr>
            <x-table-cell type="text">
                <div class="flex items-center gap-2">
                    <span class="text-2xl">{{ $item->flag_emoji ?? '🌍' }}</span>
                    <span class="font-medium text-primary">{{ $item->country_name ?? 'Unknown' }}</span>
                </div>
            </x-table-cell>
            <x-table-cell type="center"><span class="text-lg font-bold text-primary">{{ number_format($item->total) }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
@endif
@endsection
