@php
    $title = admin_trans('featured_stores');
    $icon = 'star';
@endphp

@extends('admin.analytics.base')

@section('analytics-content')
@if($data->isEmpty())
    <x-empty-state icon="star" title="No featured stores" />
@else
    <x-enhanced-table
        :headers="[
            'store' => ['text' => 'Store', 'align' => 'auto'],
            'country' => ['text' => 'Country', 'align' => 'center'],
            'offers' => ['text' => 'Offers', 'align' => 'center'],
            'followers' => ['text' => 'Followers', 'align' => 'center']
        ]"
        :responsive="true"
    >
        @foreach($data as $store)
        <tr>
            <x-table-cell type="text"><span class="font-medium text-primary">{{ $store->name }}</span></x-table-cell>
            <x-table-cell type="center">{{ $store->country_name ?? 'N/A' }}</x-table-cell>
            <x-table-cell type="center"><x-badge variant="primary">{{ number_format($store->offers_count ?? 0) }}</x-badge></x-table-cell>
            <x-table-cell type="center"><span class="font-bold text-secondary">{{ number_format($store->followers_count ?? 0) }}</span></x-table-cell>
        </tr>
        @endforeach
    </x-enhanced-table>
    @if($data->hasPages())
        <div class="mt-4"><x-pagination :paginator="$data" /></div>
    @endif
@endif
@endsection
