<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if admin already exists
        $adminExists = User::where('email', 'admin@admin.com')->exists();

        if (!$adminExists) {
            User::create([
                'name' => 'Admin',
                'email' => 'admin@admin.com',
                'password' => Hash::make('adminadmin'),
                'role' => 'admin',
                'email_verified_at' => now(),
                'language_id' => null,  // Set to null if no languages exist yet
                'country_id' => null,   // Set to null if no countries exist yet
                'current_country_id' => null,  // Set to null
            ]);

            $this->command->info('✅ Admin user created successfully!');
            $this->command->info('📧 Email: admin@admin.com');
            $this->command->info('🔒 Password: adminadmin');
        } else {
            $this->command->warn('⚠️  Admin user already exists!');
        }
    }
}