<?php

namespace App\View\Components;

use Illuminate\View\Component;

class SearchableSelect extends Component
{
    public $name;
    public $label;
    public $placeholder;
    public $options;
    public $selected;
    public $required;
    public $valueKey;
    public $labelKey;
    public $prefixKey;

    /**
     * Create a new component instance.
     */
    public function __construct(
        $name = '',
        $label = '',
        $placeholder = 'Search...',
        $options = [],
        $selected = null,
        $required = false,
        $valueKey = 'id',
        $labelKey = 'name',
        $prefixKey = null
    ) {
        $this->name = $name;
        $this->label = $label;
        $this->placeholder = $placeholder;
        $this->options = $options;
        $this->selected = $selected;
        $this->required = $required;
        $this->valueKey = $valueKey;
        $this->labelKey = $labelKey;
        $this->prefixKey = $prefixKey;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render()
    {
        return view('components.searchable-select');
    }
}
