<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->when(!$this->is_guest, $this->email),
            'phone' => $this->when(!$this->is_guest, $this->phone),
            'country_code' => $this->when(!$this->is_guest, $this->country_code),
            'e164_number' => $this->when(!$this->is_guest, $this->e164_number),
            'country_id' => $this->country_id,
            'language_id' => $this->language_id,
            'current_country_id' => $this->current_country_id,
            'role' => $this->role,
            'is_guest' => $this->is_guest,
            'is_verified' => $this->is_verified,
            'is_banned' => $this->is_banned,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            
            // Relationships
            'country' => new CountryResource($this->whenLoaded('country')),
            'current_country' => new CountryResource($this->whenLoaded('currentCountry')),
            'language' => new LanguageResource($this->whenLoaded('language')),
            
            // Counts
            'devices_count' => $this->when(
                $this->relationLoaded('devices'),
                $this->devices->count()
            ),
            'active_devices_count' => $this->when(
                $this->relationLoaded('devices'),
                $this->devices->filter(function ($device) {
                    return $device->isActive();
                })->count()
            ),
        ];
    }
}