<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class LanguageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'native_name' => $this->native_name,
            'code' => $this->code,
            'is_default' => $this->is_default,
            'status' => $this->status,
            
            // Conditional fields
            'locales' => LocaleResource::collection($this->whenLoaded('locales')),
        ];
    }
}