<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DeviceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'device_id' => $this->device_id,
            'platform' => $this->platform,
            'app_version' => $this->app_version,
            'ip_country' => $this->ip_country,
            'last_ip' => $this->when(
                auth()->check() && auth()->id() === $this->user_id,
                $this->last_ip
            ),
            'is_active' => $this->isActive(),
            'last_seen' => $this->updated_at,
            'created_at' => $this->created_at,
        ];
    }
}