<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CountryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'code' => $this->code,
            'iso_code' => $this->iso_code,
            'iso2' => $this->iso2,
            'dial_code' => $this->dial_code,
            'currency' => $this->currency,
            'currency_code' => $this->currency_code,
            'currency_symbol' => $this->currency_symbol,
            'flag_emoji' => $this->flag_emoji,
            'flag_url' => $this->flag_url,
            'is_default' => $this->is_default,
            'status' => $this->status,
            
            // Conditional fields
            'available_languages' => LanguageResource::collection(
                $this->whenLoaded('locales', function () {
                    return $this->locales->map->language->unique('id');
                })
            ),
            
            'locales' => LocaleResource::collection($this->whenLoaded('locales')),
        ];
    }
}