<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BrandResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $locale = $this->getLocaleFromRequest($request);
        
        return [
            'id' => $this->id,
            'name' => $this->getName($locale['language_id']),
            'description' => $this->getDescription($locale['language_id']),
            'is_featured' => $this->is_featured,
            'is_active' => $this->is_active,
            'order' => $this->order,
            'logo' => $this->getFirstMediaUrl('logo'),
            'offers_count' => $this->whenCounted('offers'),
            'is_subscribed' => $this->when(
                $request->user(), 
                fn() => $request->user()->isSubscribedTo($this->resource, 'follow')
            ),
        ];
    }

    /**
     * Get locale from request attributes
     */
    private function getLocaleFromRequest(Request $request): array
    {
        return [
            'country_id' => $request->attributes->get('country_id'),
            'language_id' => $request->attributes->get('language_id'),
            'locale_id' => $request->attributes->get('locale_id'),
        ];
    }
}