<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // تعريف rate limiter للـ API
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });

         // تسجيل كومبوننت TinyMCE
        Blade::component('tinymce', \App\View\Components\TinyMCE::class);
        
     

          // تسجيل الكومبوننت
        Blade::component('searchable-select', \App\View\Components\SearchableSelect::class);
        
    
    }
}