<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserProvider extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'provider',
        'provider_id',
    ];

    // Relations
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Scopes
    public function scopeByProvider($query, $provider)
    {
        return $query->where('provider', $provider);
    }

    public function scopeByProviderId($query, $providerId)
    {
        return $query->where('provider_id', $providerId);
    }

    // Helper Methods
    public static function findByProvider($provider, $providerId)
    {
        return static::where('provider', $provider)
                    ->where('provider_id', $providerId)
                    ->first();
    }

    public static function createForUser($user, $provider, $providerId)
    {
        return static::firstOrCreate([
            'user_id' => $user->id,
            'provider' => $provider,
            'provider_id' => $providerId,
        ]);
    }
}