<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PageTranslation extends Model
{
    use HasFactory;

    protected $fillable = [
        'page_id',
        'locale_id',
        'title',
        'description',
    ];

    // Relations
    public function page()
    {
        return $this->belongsTo(Page::class);
    }

    public function locale()
    {
        return $this->belongsTo(Locale::class);
    }

    // Scopes
    public function scopeByLocale($query, $localeId)
    {
        return $query->where('locale_id', $localeId);
    }

    public function scopeByPage($query, $pageId)
    {
        return $query->where('page_id', $pageId);
    }
}