<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CarouselSlideTranslation extends Model
{
    use HasFactory;

    protected $fillable = [
        'carousel_slide_id',
        'locale_id',
        'title',
        'description',
        'button_link',
        'button_text',
    ];

    // Relations
    public function carouselSlide()
    {
        return $this->belongsTo(CarouselSlide::class);
    }

    public function locale()
    {
        return $this->belongsTo(Locale::class);
    }

    // Scopes
    public function scopeByLocale($query, $localeId)
    {
        return $query->where('locale_id', $localeId);
    }

    public function scopeBySlide($query, $slideId)
    {
        return $query->where('carousel_slide_id', $slideId);
    }
}