<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
/**
 * @tags 99. Test
 */
class TestController extends Controller
{
    /**
     * Health Check
     * 
     * Check if the API is working properly
     */
    public function health(): JsonResponse
    {
        return response()->json([
            'status' => 'healthy',
            'message' => 'API is working correctly',
            'timestamp' => now()->toISOString(),
            'version' => '1.0.0',
        ]);
    }

    /**
     * API Information
     * 
     * Get basic information about the API
     */
    public function info(): JsonResponse
    {
        return response()->json([
            'app_name' => config('app.name'),
            'version' => '1.0.0',
            'environment' => config('app.env'),
            'laravel_version' => app()->version(),
        ]);
    }

    /**
     * Echo Test
     * 
     * Echo back the provided message
     */
    public function echo(Request $request): JsonResponse
    {
        $message = $request->input('message', 'Hello from API!');
        
        return response()->json([
            'echo' => $message,
            'timestamp' => now()->toISOString(),
        ]);
    }
}