<?php

if (!function_exists('admin_trans')) {
    /**
     * Get admin translation from JSON files
     * 
     * @param string $key
     * @param string|null $locale
     * @return string
     */
    function admin_trans(string $key, ?string $locale = null): string
    {
        $locale = $locale ?? session('admin_locale', config('app.locale', 'ar'));
        $filePath = base_path("lang/admin/{$locale}.json");
        
        if (!file_exists($filePath)) {
            return $key;
        }
        
        $translations = json_decode(file_get_contents($filePath), true);
        
        return $translations[$key] ?? $key;
    }
}

if (!function_exists('admin_locale')) {
    /**
     * Get current admin locale
     * 
     * @return string
     */
    function admin_locale(): string
    {
        return session('admin_locale', config('app.locale', 'ar'));
    }
}

if (!function_exists('is_rtl')) {
    /**
     * Check if current locale is RTL
     * 
     * @return bool
     */
    function is_rtl(): bool
    {
        return in_array(admin_locale(), ['ar', 'he', 'fa', 'ur']);
    }
}