# 🚀 Admin Dashboard Development Plan

## 📊 Database Dependencies (من الأقل للأكثر)

### **المستوى الأول - Zero Dependencies**
ابدأ هنا - لا يعتمد على أي جداول أخرى:

```
1. Languages (لغات النظام)
2. Countries (الدول)
3. Users (المستخدمين - خصوصاً الأدمن)
```

---

### **المستوى الثاني - Single Dependency**
يعتمد على المستوى الأول فقط:

```
4. Locales (Languages + Countries)
5. Categories (مستقل نسبياً)
6. Brands (براندات)
7. Stores (محلات - optional user_id)
8. Pages (صفحات ثابتة)
9. Carousels (سلايدرات)
```

---

### **المستوى الثالث - Multiple Dependencies**
يعتمد على أكثر من جدول:

```
11. Country_Store (Countries + Stores + Users)
12. Country_Store_Stats (Country_Store)
13. Store_Translations (Stores + Locales)
14. Category_Translations (Categories + Languages)
15. Brand_Translations (Brands + Languages)
16. Occasion_Translations (Occasions + Locales) 
17. Country_Occasion (Countries + Occasions)    
18. Page_Translations (Pages + Locales)
19. Carousel_Slides (Carousels + polymorphic linkable)
20. Carousel_Slide_Translations (Carousel_Slides + Locales)
```

---

### **المستوى الرابع - Complex Dependencies**
الأكثر تعقيداً:

```
20. Offers (Users + Country_Store + Brands)
21. Offer_Translations (Offers + Locales)
22. Category_Offer (Categories + Offers)
23. Occasion_Offer (Occasions + Offers)
24. Category_Country_Store (Categories + Country_Store)
25. Country_Occasion (Countries + Occasions)
```

---

### **المستوى الخامس - Additional Features**
ميزات إضافية:

```
26. Subscriptions (Users + polymorphic subscribable)
27. Bans (polymorphic bannable + Users)
28. Notifications (polymorphic notifiable)
29. Notification_Deliveries (Notifications + Users)
30. Notification_Targets (Notifications)
31. Media (polymorphic model + Spatie Media Library)
32. User_Devices (Users)
33. User_Locales (Users + Locales)
34. User_Providers (Users - OAuth)
35. Settings (إعدادات النظام)
```

---

## 🎯 Admin Dashboard Development Phases

### **Phase 1: Authentication & Core Setup**
الأساسيات الضرورية لبدء العمل:

```markdown
✅ Authentication System
   - Login/Logout
   - Password Reset
   - Remember Me
   - Session Management

✅ Admin Dashboard Layout
   - Sidebar Navigation
   - Top Header
   - Breadcrumbs
   - User Profile Dropdown

✅ Dashboard Home
   - Statistics Cards (Users, Stores, Offers, Categories)
   - Recent Activities
   - Charts (Offers per Month, Popular Stores)
   - Quick Actions
```

---

### **Phase 2: Languages & Localization**
إعداد اللغات والترجمة:

```markdown
✅ Languages Management
   - List all languages (DataTable)
   - Create/Edit/Delete Language
   - Set Default Language
   - Activate/Deactivate
   - Ordering (drag & drop)

✅ Countries Management
   - List all countries
   - Create/Edit/Delete Country
   - Country Translations (multi-language)
   - Currency Settings
   - Dial Codes
   - Set Default Country
   - Status Management

✅ Locales Management
   - List all locales
   - Create Locale (Language + Country)
   - Set Default Locale
   - Status Management
   - Locale Code (en-US, ar-EG, etc.)
```

---

### **Phase 3: Content Management (Categories, Brands, Occasions)**
إدارة المحتوى الأساسي:

```markdown
✅ Categories Management
   - List Categories (with translations)
   - Create/Edit/Delete Category
   - Multi-language Form (Tabs per language)
   - Featured Categories
   - Category Ordering
   - Status (draft/active)
   - Bulk Actions (delete, activate, feature)
   - Category Image Upload

✅ Brands Management
   - List Brands
   - Create/Edit/Delete Brand
   - Brand Translations
   - Featured Brands
   - Brand Ordering
   - Brand Logo Upload
   - Status Management

✅ Occasions Management
   - List Occasions
   - Create/Edit/Delete Occasion
   - Occasion Translations
   - Featured Occasions
   - Occasion Ordering
   - Occasion Image Upload
   - Link Occasions to Countries
   - Status Management
```

---

### **Phase 4: Stores Management**
إدارة المتاجر:

```markdown
✅ Stores Management
   - List All Stores
   - Create/Edit/Delete Store
   - Store Translations (Name, Description, URLs per Locale)
   - Store Logo Upload
   - Assign Store Owner (User)
   - Store Status

✅ Country-Store Relations
   - Link Store to Multiple Countries
   - Set Store Status per Country
   - Featured Store per Country
   - Store Ordering per Country
   - View Store by Country

✅ Store Statistics
   - Followers Count
   - Total Uses
   - Total Views
   - Impressions
   - Popularity Score
   - Max Discount
   - Average Discount
   - Last Offer Added Date
   - Last Usage Date
   - Export Statistics

✅ Category-Store Relations
   - Assign Categories to Country-Stores
   - Manage Store Categories per Country
```

---

### **Phase 5: Pages & Carousels**
الصفحات الثابتة والسلايدرات:

```markdown
✅ Static Pages Management
   - List Pages
   - Create/Edit/Delete Page
   - Page Translations (Title, Description per Locale)
   - Rich Text Editor for Content
   - Status Management
   - SEO Settings (Meta Title, Meta Description)

✅ Carousels Management
   - List Carousels
   - Create/Edit/Delete Carousel
   - Carousel Type (home, category, etc.)
   - Carousel Slug
   - Activate/Deactivate

✅ Carousel Slides
   - Add/Edit/Delete Slides
   - Slide Translations (Title, Description, Button Text per Locale)
   - Slide Image Upload
   - Linkable (Link to Store, Offer, Category, or Custom URL)
   - Slide Ordering (drag & drop)
   - Button Link & Button Text
```

---

### **Phase 6: Offers Management (القلب النابض)**
إدارة العروض - الأهم:

```markdown
✅ Offers Management
   - List All Offers (Advanced Filters)
   - Create/Edit/Delete Offer
   - Offer Translations (Title, Description, Final URL per Locale)
   
   - Offer Details:
     * Offer Type (code/deal)
     * Coupon Code
     * Promotion Type (monetary, percent, upto_monetary, upto_percent, custom_label)
     * Promotion Value
     * Discount Value
     * Regular Price / Sale Price
     * Currency
     * Expiry Date (Date Picker)
   
   - Offer Flags:
     * Featured Offer
     * Exclusive Offer
     * Free Shipping
     * New Customer Only
   
   - Offer Relations:
     * Select Country-Store
     * Select Brand (optional)
     * Assign Categories (multi-select)
     * Assign Occasions (multi-select)
   
   - Offer Statistics:
     * Favorites Count
     * Uses Count
     * Views Count
     * Impressions Count
     * Popularity Score
     * Last Usage Date
   
   - Offer Status:
     * Draft/Active
     * Auto-expire based on date
   
   - Bulk Actions:
     * Bulk Delete
     * Bulk Activate/Deactivate
     * Bulk Feature
     * Bulk Expire

✅ Offer Ordering
   - Store Order (per store)
   - Brand Order (per brand)
   - Drag & Drop Ordering

✅ Offer Filters & Search
   - Filter by Status
   - Filter by Type
   - Filter by Store
   - Filter by Brand
   - Filter by Category
   - Filter by Occasion
   - Filter by Featured/Exclusive
   - Filter by Expiry Date
   - Search by Title/Code
   - Date Range Filter
```

---

### **Phase 7: Users Management**
إدارة المستخدمين:

```markdown
✅ Users Management
   - List All Users
   - Create/Edit/Delete User
   - User Roles (admin, store_owner, shopper)
   - User Profile:
     * Name, Email, Phone
     * Country Code + Phone Number
     * E164 Format Phone
     * Password Management
     * Preferred Language
     * Preferred Country
     * Current Country
     * Guest Status
   
   - User Verification:
     * Email Verification
     * Phone OTP Verification
     * OTP Attempts Counter
   
   - User Status:
     * Active/Inactive
     * Ban User
     * Ban Reason
     * Ban Expiry
   
   - User Activity:
     * Last Login
     * Login History
     * Created Offers
     * Followed Stores
     * User Devices

✅ User Devices
   - List User Devices
   - Device ID
   - FCM Token (for push notifications)
   - Platform (iOS/Android)
   - Last IP
   - App Version

✅ User OAuth Providers
   - Social Login History
   - Provider (Google, Facebook, etc.)
   - Provider ID

✅ Bans Management
   - List Banned Users
   - Ban User (with reason & expiry)
   - Unban User
   - Ban History
```

---

### **Phase 8: Subscriptions**
إدارة المتابعات:

```markdown
✅ Subscriptions Management
   - List All Subscriptions
   - User Following Stores
   - User Following Brands
   - User Following Categories
   - Subscription Type (follow, notify, etc.)
   - Subscription Statistics per Store/Brand
```

---

### **Phase 9: Notifications System**
نظام الإشعارات:

```markdown
✅ Notifications Management
   - Create Notification
   - Notification Types (system, promotional, offer, etc.)
   - Notification Title & Message
   - Notification Data (JSON)
   - Notification Channels (database, push, email)
   - Notification Priority (0-10)
   - Notification Status (pending, sent, failed)

✅ Notification Targeting
   - Target All Users
   - Target Specific Users
   - Target by Role
   - Target by Country
   - Target by Locale
   - Target Followers of Store/Brand

✅ Notification Deliveries
   - Delivery Status per User
   - Read/Unread Status
   - Delivery Channel
   - Read At Timestamp

✅ Notification History
   - List All Sent Notifications
   - Notification Statistics
   - Delivery Report
   - Failed Notifications
```

---

### **Phase 10: Media Library**
إدارة الملفات والصور:

```markdown
✅ Media Management (Spatie Media Library)
   - Upload Images/Files
   - Media Collections:
     * Store Logos
     * Brand Logos
     * Category Images
     * Occasion Images
     * Carousel Slides
     * User Avatars
   
   - Image Conversions:
     * Thumbnails
     * Responsive Images
     * Optimized Sizes
   
   - Media Actions:
     * View Media
     * Download Media
     * Delete Media
     * Replace Media
   
   - Bulk Upload
   - Media Library Browser
```

---

### **Phase 11: Settings Management ⚙️**
إعدادات النظام:

```markdown
✅ General Settings
   - Site Name
   - Site Logo
   - Site Favicon
   - Site Description
   - Default Language
   - Default Country
   - Default Currency
   - Timezone
   - Date Format
   - Time Format

✅ Email Settings
   - SMTP Configuration
   - Email From Name
   - Email From Address
   - Email Templates

✅ SMS Settings
   - SMS Provider
   - SMS API Key
   - SMS From Name
   - OTP Settings:
     * OTP Length
     * OTP Expiry Time
     * Max OTP Attempts

✅ Social Media Settings
   - Facebook App ID
   - Google Client ID
   - Twitter API Key
   - Instagram URL
   - LinkedIn URL

✅ SEO Settings
   - Meta Title Template
   - Meta Description Template
   - Meta Keywords
   - Google Analytics ID
   - Facebook Pixel ID
   - Google Tag Manager

✅ Payment Settings (إذا كان فيه نظام دفع)
   - Payment Gateway
   - Payment Currency
   - Payment Methods

✅ Cache Settings
   - Clear Cache
   - Clear Route Cache
   - Clear Config Cache
   - Clear View Cache

✅ Maintenance Mode
   - Enable/Disable
   - Maintenance Message
   - Allowed IPs

✅ Localization Settings
   - RTL Support
   - Date Localization
   - Number Format
   - Currency Symbol Position

✅ Offer Settings
   - Default Offer Duration
   - Auto-expire Offers
   - Max Offers per Store
   - Featured Offers Limit

✅ Store Settings
   - Auto-approve Stores
   - Max Categories per Store
   - Verification Required

✅ User Settings
   - Registration Enabled
   - Email Verification Required
   - Phone Verification Required
   - Guest Checkout Enabled
   - Default User Role
```

---

### **Phase 12: Analytics & Reports**
التقارير والإحصائيات:

```markdown
✅ Dashboard Analytics
   - Total Users (Growth Rate)
   - Total Stores (Growth Rate)
   - Total Offers (Active/Expired)
   - Total Categories
   - Total Brands
   - Popular Stores (Most Followed)
   - Popular Offers (Most Used)
   - Recent Activities

✅ Offers Analytics
   - Offers by Status
   - Offers by Type
   - Offers by Store
   - Offers by Brand
   - Offers by Category
   - Offers Expiring Soon
   - Most Popular Offers
   - Least Popular Offers
   - Offers Usage Report

✅ Stores Analytics
   - Stores by Country
   - Featured Stores
   - Stores by Followers
   - Stores by Offers Count
   - Store Performance Report

✅ Users Analytics
   - Users by Role
   - Users by Country
   - Users by Language
   - User Growth Chart
   - Active Users
   - Banned Users
   - Guest Users

✅ Export Reports
   - Export to CSV
   - Export to Excel
   - Export to PDF
   - Date Range Selection
```

---

### **Phase 13: System Logs & Monitoring**
السجلات والمراقبة:

```markdown
✅ Activity Logs
   - User Actions Log
   - Admin Actions Log
   - System Events Log
   - Failed Login Attempts
   - API Requests Log

✅ Error Logs
   - Application Errors
   - Failed Jobs
   - Failed Notifications

✅ Audit Trail
   - Who Created What
   - Who Updated What
   - Who Deleted What
   - Timestamp
   - IP Address
   - User Agent
```

---

## 🛠️ Technical Implementation Notes

### **Laravel Backend Structure**

```php
// Controllers Structure
app/Http/Controllers/Admin/
├── DashboardController.php
├── LanguageController.php
├── CountryController.php
├── LocaleController.php
├── CategoryController.php
├── BrandController.php
├── OccasionController.php
├── StoreController.php
├── OfferController.php
├── UserController.php
├── PageController.php
├── CarouselController.php
├── NotificationController.php
├── SettingController.php
├── MediaController.php
└── ReportController.php

// Models with Translations
app/Models/
├── Language.php
├── Country.php (with CountryTranslation)
├── Locale.php
├── Category.php (with CategoryTranslation)
├── Brand.php (with BrandTranslation)
├── Occasion.php (with OccasionTranslation)
├── Store.php (with StoreTranslation)
├── CountryStore.php
├── CountryStoreStats.php
├── Offer.php (with OfferTranslation)
├── Page.php (with PageTranslation)
├── Carousel.php
├── CarouselSlide.php (with CarouselSlideTranslation)
├── User.php
├── Subscription.php
├── Ban.php
├── Notification.php
├── NotificationDelivery.php
├── NotificationTarget.php
└── Setting.php

// Policies for Authorization
app/Policies/
├── CategoryPolicy.php
├── BrandPolicy.php
├── StorePolicy.php
├── OfferPolicy.php
└── UserPolicy.php

// Form Requests for Validation
app/Http/Requests/Admin/
├── StoreCategoryRequest.php
├── UpdateCategoryRequest.php
├── StoreOfferRequest.php
└── UpdateOfferRequest.php

// Resources for API/JSON Responses
app/Http/Resources/
├── CategoryResource.php
├── BrandResource.php
├── StoreResource.php
└── OfferResource.php
```

---

### **Database Seeders Order**

```php
// database/seeders/DatabaseSeeder.php
public function run()
{
    $this->call([
        // Level 1: No dependencies
        LanguageSeeder::class,
        CountrySeeder::class,
        UserSeeder::class,
        
        // Level 2: Single dependency
        LocaleSeeder::class,
        CategorySeeder::class,
        BrandSeeder::class,
        StoreSeeder::class,
        OccasionSeeder::class, 
        
        // Level 3: Multiple dependencies
        CountryStoreSeeder::class,
        OccasionTranslationSeeder::class,
        CountryOccasionSeeder::class,
        
        // Level 4: Complex dependencies
        OfferSeeder::class,
        
        // Level 5: Additional features
        SettingSeeder::class,
    ]);
}
```

---

### **Middleware & Guards**

```php
// Middleware
app/Http/Middleware/
├── AdminMiddleware.php // Check if user is admin
├── StoreOwnerMiddleware.php // Check if user is store owner
├── LocaleMiddleware.php // Set app locale
└── BannedUserMiddleware.php // Block banned users

// Guards in config/auth.php
'guards' => [
    'admin' => [
        'driver' => 'session',
        'provider' => 'users',
    ],
],
```

---

### **Frontend Technologies (Admin Panel)**

```markdown
✅ Recommended Stack:
   - Laravel Blade Templates
   - Alpine.js (for interactivity)
   - Tailwind CSS (for styling)
   - Livewire (optional - for reactive components)

✅ Alternative:
   - Vue.js / React.js (SPA)
   - Inertia.js (Laravel + Vue/React)
   - Filament (Laravel Admin Panel)

✅ UI Components:
   - DataTables (for listing)
   - Select2 (for dropdowns)
   - Flatpickr (for date pickers)
   - Dropzone (for file uploads)
   - TinyMCE / CKEditor (for rich text)
   - SortableJS (for drag & drop)
   - Chart.js (for charts)
```

---

## 📝 Development Checklist

### **Phase 1: Setup ✅**
- [ ] Install Laravel
- [ ] Setup Database
- [ ] Run Migrations
- [ ] Create Admin User
- [ ] Setup Authentication

### **Phase 2: Languages ✅**
- [ ] Languages CRUD
- [ ] Countries CRUD
- [ ] Locales CRUD

### **Phase 3: Content ✅**
- [ ] Categories CRUD
- [ ] Brands CRUD
- [ ] Occasions CRUD

### **Phase 4: Stores ✅**
- [ ] Stores CRUD
- [ ] Country-Store Relations
- [ ] Store Statistics

### **Phase 5: Pages & Carousels ✅**
- [ ] Pages CRUD
- [ ] Carousels CRUD
- [ ] Carousel Slides CRUD

### **Phase 6: Offers ✅**
- [ ] Offers CRUD
- [ ] Offer Relations
- [ ] Offer Statistics

### **Phase 7: Users ✅**
- [ ] Users CRUD
- [ ] Roles & Permissions
- [ ] Bans Management

### **Phase 8: Notifications ✅**
- [ ] Notifications CRUD
- [ ] Notification Targeting
- [ ] Notification Delivery

### **Phase 9: Media ✅**
- [ ] Media Upload
- [ ] Media Library
- [ ] Image Conversions

### **Phase 10: Settings ✅**
- [ ] General Settings
- [ ] Email Settings
- [ ] SMS Settings
- [ ] SEO Settings

### **Phase 11: Analytics ✅**
- [ ] Dashboard Analytics
- [ ] Reports
- [ ] Export Functionality

### **Phase 12: Testing & Deploy ✅**
- [ ] Unit Tests
- [ ] Feature Tests
- [ ] Deployment

---

## 🎯 Priority Order for Development

**High Priority (Start Here):**
1. Authentication
2. Languages, Countries, Locales
3. Categories, Brands, Occasions
4. Stores
5. Offers

**Medium Priority:**
6. Users Management
7. Pages & Carousels
8. Settings

**Low Priority:**
9. Notifications
10. Media Library
11. Analytics
12. Subscriptions

---

## 📚 Additional Resources

- Laravel Documentation: https://laravel.com/docs
- Spatie Media Library: https://spatie.be/docs/laravel-medialibrary
- Laravel Translatable: https://github.com/spatie/laravel-translatable
- Filament Admin: https://filamentphp.com/

---

**Good Luck! 🚀**