import { defineConfig } from "vite";
import laravel from "laravel-vite-plugin";
import tailwindcss from "@tailwindcss/vite";
import { resolve } from "path";

export default defineConfig({
    plugins: [
        laravel({
            input: ["resources/css/app.css", "resources/js/app.js"],
            refresh: [
                "resources/**",
                "routes/**",
                "app/Http/Controllers/**",
                "resources/views/**/*.blade.php",
            ],
        }),
        tailwindcss()
    ],
    server: {
        hmr: {
            host: "localhost",
        },
        watch: {
            usePolling: true,
        },
    },
    build: {
        rollupOptions: {
            external: [],
            output: {
                manualChunks: {
                    tinymce: ['tinymce']
                    // تم حذف tom-select من الـchunks
                }
            }
        },
        commonjsOptions: {
            // دعم فقط tinymce وليس tom-select
            include: [/tinymce/, /node_modules/]
        }
    },
    resolve: {
        alias: {
            // إضافة aliases لـtinymce فقط
            '@tinymce': resolve(__dirname, 'node_modules/tinymce')
        }
    },
    optimizeDeps: {
        // تحسين dependencies لـtinymce فقط
        include: ['tinymce'],
        exclude: []
    },
    define: {
        // متغيرات عامة للجافاسكريبت بدون tom-select
        __TINYMCE_BASE_URL__: JSON.stringify('/js/tinymce/')
    },
    // إعدادات خاصة بالـ assets
    assetsInclude: [
        '**/*.woff',
        '**/*.woff2',
        '**/*.ttf',
        '**/*.eot'
    ]
});
