<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\LanguageController;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\LocaleController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\BrandController;
use App\Http\Controllers\Admin\CountryFilterController;
use App\Http\Controllers\Admin\OccasionController;
use App\Http\Controllers\Admin\StoreController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\CarouselController;
use App\Http\Controllers\Admin\OfferController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\SubscriptionController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\MediaController;


Route::get('/', function () {
    return redirect('/admin');
});

Route::get('/docs', function () {
    return redirect('/docs/api');
})->name('scramble.docs');

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
*/

Route::prefix('admin')->name('admin.')->group(function () {

    // Guest routes (not authenticated)
    Route::middleware('guest')->group(function () {
        Route::get('login', [AuthController::class, 'showLogin'])->name('login');
        Route::post('login', [AuthController::class, 'login'])->name('login.post');
    });

    Route::get('/', function () {
        return redirect()->route('admin.dashboard');
    })->name('home');


    // Locale switcher (accessible by all)
    Route::get('locale/{locale}', [AuthController::class, 'switchLocale'])->name('locale');

    // Authenticated admin routes
    Route::middleware('admin')->group(function () {
        // Main Dashboard
        Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

        // API Endpoints for Dashboard Data
        Route::group(['prefix' => 'api/dashboard'], function () {
            Route::get('/stats', [DashboardController::class, 'getStats'])->name('dashboard.api.stats');
            Route::get('/charts', [DashboardController::class, 'getCharts'])->name('dashboard.api.charts');
            Route::get('/activities', [DashboardController::class, 'getActivities'])->name('dashboard.api.activities');
        });

        Route::post('logout', [AuthController::class, 'logout'])->name('logout');

        // Design System Demo (للتطوير فقط)
        Route::get('design-system', function () {
            return view('admin.design-system');
        })->name('design-system');

        // Country Filter Routes
        Route::get('/country-filter', [CountryFilterController::class, 'getFilter'])->name('country-filter.get');
        Route::post('/country-filter', [CountryFilterController::class, 'setFilter'])->name('country-filter.set');
        Route::delete('/country-filter', [CountryFilterController::class, 'clearFilter'])->name('country-filter.clear');


        // Users Management
        Route::prefix('users')->name('users.')->group(function () {
            Route::get('/', [UserController::class, 'index'])->name('index');
            Route::post('/', [UserController::class, 'store'])->name('store');
            Route::get('/{user}/edit', [UserController::class, 'edit'])->name('edit');
            Route::put('/{user}', [UserController::class, 'update'])->name('update');
            Route::delete('/{user}', [UserController::class, 'destroy'])->name('destroy');
            Route::post('/{user}/ban', [UserController::class, 'ban'])->name('ban');
            Route::post('/{user}/unban', [UserController::class, 'unban'])->name('unban');
            Route::post('/{user}/verify-email', [UserController::class, 'verifyEmail'])->name('verify-email');
            Route::post('/{user}/unverify-email', [UserController::class, 'unverifyEmail'])->name('unverify-email');
            Route::get('/{user}/devices', [UserController::class, 'devices'])->name('devices');
            Route::get('/{user}/activity', [UserController::class, 'activity'])->name('activity');
            Route::post('/bulk-action', [UserController::class, 'bulkAction'])->name('bulk-action');
            Route::get('/export', [UserController::class, 'export'])->name('export');
        });

        // Stores Management
        Route::prefix('stores')->name('stores.')->group(function () {
            Route::get('/', [StoreController::class, 'index'])->name('index');
            Route::post('/', [StoreController::class, 'store'])->name('store');
            Route::get('/{store}/edit', [StoreController::class, 'edit'])->name('edit');
            Route::put('/{store}', [StoreController::class, 'update'])->name('update');
            Route::delete('/{store}', [StoreController::class, 'destroy'])->name('destroy');
            Route::post('/update-order', [StoreController::class, 'updateOrder'])->name('update-order');
            Route::patch('/{store}/toggle-status', [StoreController::class, 'toggleStatus'])->name('toggle-status');
            Route::patch('/{store}/toggle-featured', [StoreController::class, 'toggleFeatured'])->name('toggle-featured');
            Route::post('/bulk-action', [StoreController::class, 'bulkAction'])->name('bulk-action');
            Route::delete('/{store}/media/{collection}', [StoreController::class, 'removeMedia'])->name('remove-media');
            Route::get('/countries/{country}/locales', [StoreController::class, 'getLocalesForCountry'])->name('countries.locales');
            Route::get('/{store}/stats', [StoreController::class, 'getStats'])->name('stats');
        });

        // Offers Management
        Route::prefix('offers')->name('offers.')->group(function () {
            Route::get('/', [OfferController::class, 'index'])->name('index');
            Route::get('/create', [OfferController::class, 'create'])->name('create');
            Route::post('/', [OfferController::class, 'store'])->name('store');
            Route::get('/{offer}/edit', [OfferController::class, 'edit'])->name('edit');
            Route::put('/{offer}', [OfferController::class, 'update'])->name('update');
            Route::delete('/{offer}', [OfferController::class, 'destroy'])->name('destroy');
            Route::patch('/{offer}/toggle-status', [OfferController::class, 'toggleStatus'])->name('toggle-status');
            Route::patch('/{offer}/toggle-featured', [OfferController::class, 'toggleFeatured'])->name('toggle-featured');
            Route::post('/bulk-action', [OfferController::class, 'bulkAction'])->name('bulk-action');
            Route::delete('/{offer}/media/{collection}/{mediaId}', [OfferController::class, 'removeMedia'])->name('remove-media');
            Route::get('/{offer}/stats', [OfferController::class, 'getStats'])->name('stats');
            
            // إضافة راوتس البحث للكومبوننت
            Route::get('/search/stores', [OfferController::class, 'searchStores'])->name('search.stores');
            Route::get('/search/brands', [OfferController::class, 'searchBrands'])->name('search.brands');
            Route::get('/search/categories', [OfferController::class, 'searchCategories'])->name('search.categories');
            Route::get('/search/occasions', [OfferController::class, 'searchOccasions'])->name('search.occasions');
        });

        // Occasions Management
        Route::prefix('occasions')->name('occasions.')->group(function () {
            Route::get('/', [OccasionController::class, 'index'])->name('index');
            Route::post('/', [OccasionController::class, 'store'])->name('store');
            Route::get('/{occasion}/edit', [OccasionController::class, 'edit'])->name('edit');
            Route::put('/{occasion}', [OccasionController::class, 'update'])->name('update');
            Route::delete('/{occasion}', [OccasionController::class, 'destroy'])->name('destroy');
            Route::post('/update-order', [OccasionController::class, 'updateOrder'])->name('update-order');
            Route::patch('/{occasion}/toggle-status', [OccasionController::class, 'toggleStatus'])->name('toggle-status');
            Route::patch('/{occasion}/toggle-featured', [OccasionController::class, 'toggleFeatured'])->name('toggle-featured');
            Route::post('/bulk-action', [OccasionController::class, 'bulkAction'])->name('bulk-action');
            Route::delete('/{occasion}/media/{collection}', [OccasionController::class, 'removeMedia'])->name('remove-media');
            Route::get('/countries/{country}/locales', [OccasionController::class, 'getLocalesForCountry'])->name('countries.locales');
        });

        // Categories Management
        Route::prefix('categories')->name('categories.')->group(function () {
            Route::get('/', [CategoryController::class, 'index'])->name('index');
            Route::post('/', [CategoryController::class, 'store'])->name('store');
            Route::get('/{category}/edit', [CategoryController::class, 'edit'])->name('edit');
            Route::put('/{category}', [CategoryController::class, 'update'])->name('update');
            Route::delete('/{category}', [CategoryController::class, 'destroy'])->name('destroy');
            Route::post('/update-order', [CategoryController::class, 'updateOrder'])->name('update-order');
            Route::patch('/{category}/toggle-status', [CategoryController::class, 'toggleStatus'])->name('toggle-status');
            Route::patch('/{category}/toggle-featured', [CategoryController::class, 'toggleFeatured'])->name('toggle-featured');
            Route::post('/bulk-action', [CategoryController::class, 'bulkAction'])->name('bulk-action');
            Route::delete('/{category}/media/{collection}', [CategoryController::class, 'removeMedia'])->name('remove-media');
        });



        // Pages Management
        Route::prefix('pages')->name('pages.')->group(function () {
            Route::get('/', [PageController::class, 'index'])->name('index');
            Route::post('/', [PageController::class, 'store'])->name('store');
            Route::get('/{page}/edit', [PageController::class, 'edit'])->name('edit');
            Route::put('/{page}', [PageController::class, 'update'])->name('update');
            Route::delete('/{page}', [PageController::class, 'destroy'])->name('destroy');
            Route::patch('/{page}/toggle-status', [PageController::class, 'toggleStatus'])->name('toggle-status');
            Route::post('/bulk-action', [PageController::class, 'bulkAction'])->name('bulk-action');
        });


        // Carousels Management
        Route::prefix('carousels')->name('carousels.')->group(function () {
            Route::get('/', [CarouselController::class, 'index'])->name('index');
            Route::post('/', [CarouselController::class, 'store'])->name('store');
            Route::get('/{carousel}', [CarouselController::class, 'show'])->name('show');
            Route::put('/{carousel}', [CarouselController::class, 'update'])->name('update');
            Route::delete('/{carousel}', [CarouselController::class, 'destroy'])->name('destroy');
            Route::patch('/{carousel}/toggle-status', [CarouselController::class, 'toggleStatus'])->name('toggle-status');
            Route::post('/bulk-action', [CarouselController::class, 'bulkAction'])->name('bulk-action');

            // Slides Management
            Route::post('/{carousel}/slides', [CarouselController::class, 'storeSlide'])->name('slides.store');
            Route::get('/slides/{slide}/edit', [CarouselController::class, 'editSlide'])->name('slides.edit');
            Route::put('/slides/{slide}', [CarouselController::class, 'updateSlide'])->name('slides.update');
            Route::delete('/slides/{slide}', [CarouselController::class, 'destroySlide'])->name('slides.destroy');
        });


        // Brands Management
        Route::prefix('brands')->name('brands.')->group(function () {
            Route::get('/', [BrandController::class, 'index'])->name('index');
            Route::post('/', [BrandController::class, 'store'])->name('store');
            Route::get('/{brand}/edit', [BrandController::class, 'edit'])->name('edit');
            Route::put('/{brand}', [BrandController::class, 'update'])->name('update');
            Route::delete('/{brand}', [BrandController::class, 'destroy'])->name('destroy');
            Route::post('/update-order', [BrandController::class, 'updateOrder'])->name('update-order');
            Route::patch('/{brand}/toggle-status', [BrandController::class, 'toggleStatus'])->name('toggle-status');
            Route::patch('/{brand}/toggle-featured', [BrandController::class, 'toggleFeatured'])->name('toggle-featured');
            Route::post('/bulk-action', [BrandController::class, 'bulkAction'])->name('bulk-action');
            Route::delete('/{brand}/media/{collection}', [BrandController::class, 'removeMedia'])->name('remove-media');
        });



        // Countries Management
        Route::prefix('countries')->name('countries.')->group(function () {
            Route::get('/', [CountryController::class, 'index'])->name('index');
            Route::post('/', [CountryController::class, 'store'])->name('store');
            Route::put('/{country}', [CountryController::class, 'update'])->name('update');
            Route::delete('/{country}', [CountryController::class, 'destroy'])->name('destroy');
            Route::post('/update-order', [CountryController::class, 'updateOrder'])->name('update-order');
            Route::patch('/{country}/toggle-status', [CountryController::class, 'toggleStatus'])->name('toggle-status');
            Route::patch('/{country}/set-default', [CountryController::class, 'setDefault'])->name('set-default');
            Route::post('/fetch-api', [CountryController::class, 'fetchFromApi'])->name('fetch-api');
            Route::patch('/{country}/update-flag', [CountryController::class, 'updateFlag'])->name('update-flag');
            Route::get('/{country}/translations', [CountryController::class, 'translations'])->name('translations');
            Route::post('/{country}/translations', [CountryController::class, 'storeTranslation'])->name('store-translation');
        });


        // Locales Management  
        Route::prefix('locales')->name('locales.')->group(function () {
            Route::get('/', [LocaleController::class, 'index'])->name('index');
            Route::post('/', [LocaleController::class, 'store'])->name('store');
            Route::put('/{locale}', [LocaleController::class, 'update'])->name('update');
            Route::delete('/{locale}', [LocaleController::class, 'destroy'])->name('destroy');
            Route::post('/update-order', [LocaleController::class, 'updateOrder'])->name('update-order');
            Route::patch('/{locale}/toggle-status', [LocaleController::class, 'toggleStatus'])->name('toggle-status');
            Route::patch('/{locale}/set-default', [LocaleController::class, 'setDefault'])->name('set-default');
        });

        // Languages Management
        Route::prefix('languages')->name('languages.')->group(function () {
            Route::get('/', [LanguageController::class, 'index'])->name('index');
            Route::post('/', [LanguageController::class, 'store'])->name('store');
            Route::put('/{language}', [LanguageController::class, 'update'])->name('update');
            Route::delete('/{language}', [LanguageController::class, 'destroy'])->name('destroy');
            Route::post('/update-order', [LanguageController::class, 'updateOrder'])->name('update-order');
            Route::patch('/{language}/toggle-status', [LanguageController::class, 'toggleStatus'])->name('toggle-status');
            Route::patch('/{language}/set-default', [LanguageController::class, 'setDefault'])->name('set-default');
        });

        // Subscriptions Management
        Route::prefix('subscriptions')->name('subscriptions.')->group(function () {
            Route::get('/', [SubscriptionController::class, 'index'])->name('index');
            Route::delete('/{subscription}', [SubscriptionController::class, 'destroy'])->name('destroy');
            Route::post('/bulk-action', [SubscriptionController::class, 'bulkAction'])->name('bulk-action');
            Route::get('/export', [SubscriptionController::class, 'export'])->name('export');
            Route::get('/stats/stores', [SubscriptionController::class, 'storeStats'])->name('stats.stores');
            Route::get('/stats/brands', [SubscriptionController::class, 'brandStats'])->name('stats.brands');
            Route::get('/stats/categories', [SubscriptionController::class, 'categoryStats'])->name('stats.categories');
        });

        // Notifications Management
        Route::prefix('notifications')->name('notifications.')->group(function () {
            Route::get('/', [NotificationController::class, 'index'])->name('index');
            Route::get('/stats', [NotificationController::class, 'stats'])->name('stats');
            Route::get('/create', [NotificationController::class, 'create'])->name('create');
            Route::post('/', [NotificationController::class, 'store'])->name('store');
            Route::get('/{notification}', [NotificationController::class, 'show'])->name('show');
            Route::delete('/{notification}', [NotificationController::class, 'destroy'])->name('destroy');
            Route::post('/{notification}/resend', [NotificationController::class, 'resend'])->name('resend');
            Route::post('/bulk-action', [NotificationController::class, 'bulkAction'])->name('bulk-action');
            Route::get('/{notification}/delivery-report', [NotificationController::class, 'deliveryReport'])->name('delivery-report');
        });

        // Admin Profile Routes
        Route::prefix('profile')->name('profile.')->group(function () {
            Route::get('/', [ProfileController::class, 'show'])->name('show');
            Route::put('/update', [ProfileController::class, 'updateProfile'])->name('update');
            Route::put('/password', [ProfileController::class, 'updatePassword'])->name('password');
            Route::get('/data', [ProfileController::class, 'getProfileData'])->name('data');
            Route::put('/preferences', [ProfileController::class, 'updatePreferences'])->name('preferences');
        });

        // Settings Management
        Route::prefix('settings')->name('settings.')->group(function () {
            Route::get('/', [SettingsController::class, 'index'])->name('index');
            Route::put('/general', [SettingsController::class, 'updateGeneral'])->name('general');
            Route::put('/email', [SettingsController::class, 'updateEmail'])->name('email');
            Route::put('/social', [SettingsController::class, 'updateSocial'])->name('social');
            Route::put('/seo', [SettingsController::class, 'updateSeo'])->name('seo');
            Route::put('/cache', [SettingsController::class, 'updateCache'])->name('cache');
            Route::post('/clear-cache', [SettingsController::class, 'clearCache'])->name('clear-cache');
            Route::post('/test-email', [SettingsController::class, 'testEmail'])->name('test-email');
            Route::post('/copy-seo', [SettingsController::class, 'copySeoSettings'])->name('copy-seo');
        });
        
        // Media Management
        Route::prefix('media')->name('media.')->group(function () {
            Route::get('/', [MediaController::class, 'index'])->name('index');
            Route::get('/create', [MediaController::class, 'create'])->name('create');
            Route::post('/upload', [MediaController::class, 'upload'])->name('upload');
            Route::get('/{media}/edit', [MediaController::class, 'edit'])->name('edit');
            Route::put('/{media}', [MediaController::class, 'update'])->name('update');
            Route::get('/{media}', [MediaController::class, 'show'])->name('show');
            Route::delete('/{media}', [MediaController::class, 'destroy'])->name('destroy');
            Route::get('/{media}/download', [MediaController::class, 'download'])->name('download');
            Route::post('/bulk-action', [MediaController::class, 'bulkAction'])->name('bulk-action');
            Route::post('/model-items', [MediaController::class, 'getModelItems'])->name('model-items');
            Route::post('/cleanup', [MediaController::class, 'cleanup'])->name('cleanup');
            Route::get('/api/stats', [MediaController::class, 'getStats'])->name('stats');
        });
        
        // Generic Searchable Select API routes
        Route::prefix('searchable-select')->name('searchable-select.')->group(function () {
            Route::get('/search', function (Request $request) {
                $type = $request->get('type');
                $search = $request->get('search', '');
                $currentCountry = current_filtered_country();
                
                $options = [];
                
                switch ($type) {
                    case 'stores':
                        if ($currentCountry) {
                            $options = \App\Models\CountryStore::where('country_id', $currentCountry->id)
                                ->with(['store.translations'])
                                ->whereHas('store.translations', function ($query) use ($search) {
                                    $query->where('name', 'like', "%{$search}%");
                                })
                                ->where('status', 'active')
                                ->limit(20)
                                ->get()
                                ->map(function ($countryStore) {
                                    $storeTranslation = $countryStore->store->translations->first();
                                    return [
                                        'value' => $countryStore->id,
                                        'text' => $storeTranslation->name ?? 'Store #' . $countryStore->store_id,
                                        'icon' => '🏪',
                                        'subtitle' => $countryStore->store->website ?? '',
                                    ];
                                });
                        }
                        break;
                        
                    case 'brands':
                        $options = \App\Models\Brand::with(['translations'])
                            ->whereHas('translations', function ($query) use ($search) {
                                $query->where('name', 'like', "%{$search}%");
                            })
                            ->where('status', 'active')
                            ->limit(20)
                            ->get()
                            ->map(function ($brand) {
                                $brandTranslation = $brand->translations->first();
                                return [
                                    'value' => $brand->id,
                                    'text' => $brandTranslation->name ?? 'Brand #' . $brand->id,
                                    'icon' => '🏷️',
                                    'subtitle' => $brand->website ?? '',
                                ];
                            });
                        break;
                        
                    case 'categories':
                        $options = \App\Models\Category::with(['translations'])
                            ->whereHas('translations', function ($query) use ($search) {
                                $query->where('name', 'like', "%{$search}%");
                            })
                            ->where('status', 'active')
                            ->limit(20)
                            ->get()
                            ->map(function ($category) {
                                $categoryTranslation = $category->translations->first();
                                return [
                                    'value' => $category->id,
                                    'text' => $categoryTranslation->name ?? 'Category #' . $category->id,
                                    'icon' => $category->emoji ?? '📂',
                                    'color' => $category->color,
                                ];
                            });
                        break;
                        
                    case 'occasions':
                        $options = \App\Models\Occasion::with(['translations'])
                            ->whereHas('translations', function ($query) use ($search) {
                                $query->where('name', 'like', "%{$search}%");
                            })
                            ->where('status', 'active')
                            ->limit(20)
                            ->get()
                            ->map(function ($occasion) {
                                $occasionTranslation = $occasion->translations->first();
                                return [
                                    'value' => $occasion->id,
                                    'text' => $occasionTranslation->name ?? 'Occasion #' . $occasion->id,
                                    'icon' => $occasion->emoji ?? '🎉',
                                    'subtitle' => $occasion->start_date?->format('Y-m-d'),
                                ];
                            });
                        break;
                        
                    default:
                        return response()->json(['error' => 'Invalid type'], 400);
                }
                
                return response()->json(['options' => $options]);
            })->name('search');
        });
    });
});