@props([
    'title',
    'value',
    'icon',
    'trend' => null,
    'trendDirection' => 'up',
    'trendValue' => null,
    'gradient' => 'primary',
])

@php
$gradientClass = match($gradient) {
    'primary' => 'gradient-primary',
    'secondary' => 'gradient-secondary',
    'success' => 'bg-gradient-to-r from-green-500 to-green-600',
    'warning' => 'bg-gradient-to-r from-yellow-500 to-orange-600',
    'danger' => 'bg-gradient-to-r from-red-500 to-red-600',
    default => 'gradient-primary',
};

$trendVariant = match($trendDirection) {
    'up' => 'success',
    'down' => 'danger',
    default => 'info',
};

$trendIcon = match($trendDirection) {
    'up' => 'trending-up',
    'down' => 'trending-down',
    default => 'minus',
};
@endphp

<div class="card hover:shadow-xl transition-all hover:-translate-y-1">
    <div class="flex items-center justify-between">
        <div>
            <p class="text-sm font-medium text-secondary">{{ $title }}</p>
            <h3 class="text-3xl font-bold mt-2 text-primary">{{ $value }}</h3>
        </div>
        <div class="w-14 h-14 rounded-xl flex items-center justify-center {{ $gradientClass }} shadow-lg">
            <i data-lucide="{{ $icon }}" class="w-7 h-7 text-white"></i>
        </div>
    </div>
    @if($trend)
        <div class="mt-4 flex items-center gap-2">
            <x-badge :variant="$trendVariant" :icon="$trendIcon">
                {{ $trendValue ?? $trend }}
            </x-badge>
            <span class="text-xs text-tertiary">{{ $trend }}</span>
        </div>
    @endif
</div>
