@props([
    'paginator',
    'simple' => false,
])

@if ($paginator->hasPages())
<div class="flex items-center justify-between">
    <div class="text-sm text-tertiary">
        عرض {{ $paginator->firstItem() }} إلى {{ $paginator->lastItem() }} من {{ $paginator->total() }} نتيجة
    </div>
    
    <nav class="flex items-center gap-1">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
            <span class="px-3 py-2 text-tertiary cursor-not-allowed">
                <i data-lucide="chevron-{{ is_rtl() ? 'right' : 'left' }}" class="w-4 h-4"></i>
            </span>
        @else
            <a href="{{ $paginator->previousPageUrl() }}" 
               class="px-3 py-2 rounded-lg transition-colors hover:bg-primary-light text-primary">
                <i data-lucide="chevron-{{ is_rtl() ? 'right' : 'left' }}" class="w-4 h-4"></i>
            </a>
        @endif

        {{-- Pagination Elements --}}
        @if(!$simple)
            @foreach ($paginator->getUrlRange(1, $paginator->lastPage()) as $page => $url)
                @if ($page == $paginator->currentPage())
                    <span class="px-3 py-2 rounded-lg text-white font-medium gradient-primary">{{ $page }}</span>
                @else
                    <a href="{{ $url }}" 
                       class="px-3 py-2 rounded-lg transition-colors hover:bg-primary-light text-primary">{{ $page }}</a>
                @endif
            @endforeach
        @endif

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
            <a href="{{ $paginator->nextPageUrl() }}" 
               class="px-3 py-2 rounded-lg transition-colors hover:bg-primary-light text-primary">
                <i data-lucide="chevron-{{ is_rtl() ? 'left' : 'right' }}" class="w-4 h-4"></i>
            </a>
        @else
            <span class="px-3 py-2 text-tertiary cursor-not-allowed">
                <i data-lucide="chevron-{{ is_rtl() ? 'left' : 'right' }}" class="w-4 h-4"></i>
            </span>
        @endif
    </nav>
</div>
@endif