@props([
    'label' => null,
    'name' => null,
    'type' => 'text',
    'size' => 'md',
    'error' => null,
    'hint' => null,
    'icon' => null,
    'iconPosition' => 'left',
    'required' => false,
    'disabled' => false,
])

@php
$id = $attributes->get('id') ?? $name ?? 'input-' . uniqid();
$inputClasses = 'input';

// Size classes
$inputClasses .= match($size) {
    'sm' => ' input-sm',
    'lg' => ' input-lg',
    default => '',
};

// Icon padding with proper RTL support - زي صفحة اللوجين
if ($icon) {
    if ($iconPosition === 'right') {
        // Right icon: نفس منطق اللوجين معكوس
        $inputClasses .= ' ' . (is_rtl() ? 'pl-10' : 'pr-10');
    } else {
        // Left icon: نفس منطق اللوجين بالضبط
        $inputClasses .= ' ' . (is_rtl() ? 'pr-10' : 'pl-10');
    }
}

// Error state
if ($error) {
    $inputClasses .= ' error';
}

$inputClasses .= ' ' . ($attributes->get('class') ?? '');

// Icon positioning classes with RTL support - زي صفحة اللوجين
if ($icon) {
    if ($iconPosition === 'right') {
        // Right icon position - عكس اللوجين
        $iconClasses = is_rtl() ? 'right-0 pr-3' : 'left-0 pl-3';
    } else {
        // Left icon position - زي اللوجين بالضبط
        $iconClasses = is_rtl() ? 'left-0 pl-3' : 'right-0 pr-3';
    }
}
@endphp

<div class="w-full">
    @if($label)
        <label for="{{ $id }}" class="block text-sm font-semibold mb-2 text-primary">
            {{ $label }}
            @if($required)
                <span class="text-red-500">*</span>
            @endif
        </label>
    @endif

    <div class="relative">
        @if($icon)
            <div class="absolute inset-y-0 {{ $iconClasses }} flex items-center pointer-events-none">
                <i data-lucide="{{ $icon }}" class="w-5 h-5 text-tertiary"></i>
            </div>
        @endif

        <input
            type="{{ $type }}"
            id="{{ $id }}"
            name="{{ $name }}"
            {{ $attributes->merge(['class' => $inputClasses]) }}
            @if($required) required @endif
            @if($disabled) disabled @endif
        >
    </div>

    @if($error)
        <p class="mt-2 text-xs flex items-center gap-1.5" style="color: var(--color-danger-500);">
            <i data-lucide="alert-circle" class="w-4 h-4"></i>
            {{ $error }}
        </p>
    @endif

    @if($hint && !$error)
        <p class="mt-2 text-xs text-tertiary">
            {{ $hint }}
        </p>
    @endif
</div>