@props([
    'icon' => 'inbox',
    'title' => 'No data found',
    'description' => 'Get started by creating a new item',
    'actionText' => null,
    'actionUrl' => null,
])

<div class="flex flex-col items-center justify-center py-12 px-4 text-center">
    <!-- Icon -->
    <div class="w-20 h-20 rounded-2xl flex items-center justify-center mb-4" 
         style="background: var(--color-bg-secondary);">
        <i data-lucide="{{ $icon }}" class="w-10 h-10 text-tertiary"></i>
    </div>

    <!-- Title -->
    <h3 class="text-lg font-semibold mb-2 text-primary">
        {{ $title }}
    </h3>

    <!-- Description -->
    <p class="text-sm text-secondary mb-6 max-w-md">
        {{ $description }}
    </p>

    <!-- Action Button -->
    @if($actionText && $actionUrl)
        <x-button :href="$actionUrl" icon="plus">
            {{ $actionText }}
        </x-button>
    @endif

    {{ $slot }}
</div>