@props([
    'variant' => 'primary',
    'size' => 'md',
    'icon' => null,
    'iconPosition' => 'left',
    'loading' => false,
    'disabled' => false,
    'href' => null,
    'type' => 'button',
])

@php
$classes = 'btn';

// Variant classes
$classes .= match($variant) {
    'primary' => ' btn-primary',
    'secondary' => ' btn-secondary',
    'outline' => ' btn-outline',
    'ghost' => ' btn-ghost',
    'danger' => ' btn-danger',
    default => ' btn-primary',
};

// Size classes
$classes .= match($size) {
    'sm' => ' btn-sm',
    'lg' => ' btn-lg',
    'icon' => ' btn-icon',
    default => '',
};

// Additional classes
$classes .= ' ' . ($attributes->get('class') ?? '');

$isDisabled = $disabled || $loading;
@endphp

@if($href && !$isDisabled)
    <a href="{{ $href }}" {{ $attributes->merge(['class' => $classes]) }}>
        @if($loading)
            <svg class="animate-spin h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
            </svg>
        @else
            @if($icon && $iconPosition === 'left')
                <i data-lucide="{{ $icon }}" class="w-5 h-5"></i>
            @endif

            {{ $slot }}

            @if($icon && $iconPosition === 'right')
                <i data-lucide="{{ $icon }}" class="w-5 h-5"></i>
            @endif
        @endif
    </a>
@else
    <button 
        type="{{ $type }}"
        {{ $attributes->merge(['class' => $classes]) }}
        @if($isDisabled) disabled @endif
    >
        @if($loading)
            <svg class="animate-spin h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
            </svg>
        @else
            @if($icon && $iconPosition === 'left')
                <i data-lucide="{{ $icon }}" class="w-5 h-5"></i>
            @endif

            {{ $slot }}

            @if($icon && $iconPosition === 'right')
                <i data-lucide="{{ $icon }}" class="w-5 h-5"></i>
            @endif
        @endif
    </button>
@endif