@props([
    'icon',
    'iconColor' => 'primary',
    'title',
    'description',
    'time',
])

@php
$iconBgColor = match($iconColor) {
    'primary' => 'var(--color-primary-light)',
    'secondary' => 'var(--color-secondary-light)',
    'success' => 'var(--color-success-50)',
    'warning' => 'rgba(251, 191, 36, 0.1)',
    'danger' => 'var(--color-danger-50)',
    'purple' => 'rgba(139, 92, 246, 0.1)',
    default => 'var(--color-primary-light)',
};

$iconTextColor = match($iconColor) {
    'primary' => 'var(--color-primary)',
    'secondary' => 'var(--color-secondary)',
    'success' => 'var(--color-success-500)',
    'warning' => '#FBBF24',
    'danger' => 'var(--color-danger-500)',
    'purple' => '#8B5CF6',
    default => 'var(--color-primary)',
};
@endphp

<div class="flex items-start gap-4 p-4 rounded-xl transition-all cursor-pointer hover:bg-primary-light">
    <div class="w-10 h-10 rounded-xl flex items-center justify-center flex-shrink-0" 
         style="background: {{ $iconBgColor }};">
        <i data-lucide="{{ $icon }}" class="w-5 h-5" style="color: {{ $iconTextColor }};"></i>
    </div>
    <div class="flex-1">
        <h4 class="font-semibold text-sm mb-1 text-primary">{{ $title }}</h4>
        <p class="text-sm text-secondary">{{ $description }}</p>
        <p class="text-xs mt-1.5 flex items-center gap-1 text-tertiary">
            <i data-lucide="clock" class="w-3 h-3"></i>
            {{ $time }}
        </p>
    </div>
</div>

