@extends('admin.layouts.app')

@section('title', admin_trans('settings'))
@section('page-title', admin_trans('settings'))

@section('content')

<div class="space-y-6">
    
    <!-- Settings Navigation -->
    <div class="card">
        <x-tabs defaultTab="general">
            <!-- Tab Headers -->
            <div class="flex border-b overflow-x-auto" style="border-color: var(--color-border);">
                <x-tab-button tab="general" icon="settings">
                    {{ admin_trans('general_settings') }}
                </x-tab-button>
                <x-tab-button tab="email" icon="mail">
                    {{ admin_trans('email_settings') }}
                </x-tab-button>
                <x-tab-button tab="social" icon="share-2">
                    {{ admin_trans('social_media') }}
                </x-tab-button>
                <x-tab-button tab="seo" icon="search">
                    {{ admin_trans('seo_settings') }}
                    @if($currentCountry)
                        <x-badge variant="info" class="ml-2">{{ $currentCountry->name }}</x-badge>
                    @endif
                </x-tab-button>
                <x-tab-button tab="cache" icon="database">
                    {{ admin_trans('cache_settings') }}
                </x-tab-button>
            </div>

            <!-- General Settings Tab -->
            <x-tab-content tab="general" class="p-6">
                <form method="POST" action="{{ route('admin.settings.general') }}" enctype="multipart/form-data" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- App Name -->
                        <x-input 
                            :label="admin_trans('app_name')"
                            name="app_name"
                            value="{{ $settings['general']['app_name'] ?? 'Qansah' }}"
                            :required="true"
                            icon="tag"
                            :hint="admin_trans('app_name_hint')"
                        />

                        <!-- App Version -->
                        <x-input 
                            :label="admin_trans('app_version')"
                            name="app_version"
                            value="{{ $settings['general']['app_version'] ?? '1.0.0' }}"
                            :required="true"
                            icon="layers"
                            :hint="admin_trans('app_version_hint')"
                        />
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Site Logo -->
                        <div>
                            <label class="block text-sm font-semibold mb-2 text-primary">
                                {{ admin_trans('site_logo') }}
                            </label>
                            
                            <!-- Current Logo Preview -->
                            @if($settings['general']['site_logo'] ?? null)
                                <div class="mb-4 p-4 rounded-xl" style="background: var(--color-bg-secondary);">
                                    <div class="flex items-center gap-3">
                                        <img src="{{ $settings['general']['site_logo'] }}" 
                                             alt="Current Logo" 
                                             class="h-12 w-auto">
                                        <div>
                                            <p class="text-sm font-medium text-primary">{{ admin_trans('current_logo') }}</p>
                                            <p class="text-xs text-tertiary">{{ admin_trans('upload_new_to_replace') }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <input type="file" 
                                   name="site_logo" 
                                   accept="image/*"
                                   class="input">
                            <p class="mt-2 text-xs text-tertiary">
                                SVG, PNG, JPG ({{ admin_trans('max_2mb') }})
                            </p>
                        </div>

                        <!-- Site Favicon -->
                        <div>
                            <label class="block text-sm font-semibold mb-2 text-primary">
                                {{ admin_trans('site_favicon') }}
                            </label>
                            
                            <!-- Current Favicon Preview -->
                            @if($settings['general']['site_favicon'] ?? null)
                                <div class="mb-4 p-4 rounded-xl" style="background: var(--color-bg-secondary);">
                                    <div class="flex items-center gap-3">
                                        <img src="{{ $settings['general']['site_favicon'] }}" 
                                             alt="Current Favicon" 
                                             class="h-8 w-8">
                                        <div>
                                            <p class="text-sm font-medium text-primary">{{ admin_trans('current_favicon') }}</p>
                                            <p class="text-xs text-tertiary">{{ admin_trans('upload_new_to_replace') }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <input type="file" 
                                   name="site_favicon" 
                                   accept=".ico,.png"
                                   class="input">
                            <p class="mt-2 text-xs text-tertiary">
                                ICO, PNG ({{ admin_trans('max_1mb') }})
                            </p>
                        </div>
                    </div>

                    <div class="flex justify-end">
                        <x-button variant="primary" type="submit" icon="check">
                            {{ admin_trans('save_changes') }}
                        </x-button>
                    </div>
                </form>
            </x-tab-content>

            <!-- Email Settings Tab -->
            <x-tab-content tab="email" class="p-6">
                <form method="POST" action="{{ route('admin.settings.email') }}" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <x-input 
                            :label="admin_trans('smtp_host')"
                            name="smtp_host"
                            value="{{ $settings['email']['smtp_host'] ?? '' }}"
                            :required="true"
                            placeholder="smtp.gmail.com"
                        />

                        <x-input 
                            :label="admin_trans('smtp_port')"
                            name="smtp_port"
                            type="number"
                            value="{{ $settings['email']['smtp_port'] ?? '587' }}"
                            :required="true"
                        />
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <x-input 
                            :label="admin_trans('smtp_username')"
                            name="smtp_username"
                            type="email"
                            value="{{ $settings['email']['smtp_username'] ?? '' }}"
                            :required="true"
                        />

                        <x-input 
                            :label="admin_trans('smtp_password')"
                            name="smtp_password"
                            type="password"
                            :hint="admin_trans('leave_empty_to_keep_current')"
                        />
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <x-select 
                            :label="admin_trans('smtp_encryption')"
                            name="smtp_encryption"
                            :required="true"
                        >
                            <option value="tls" {{ ($settings['email']['smtp_encryption'] ?? 'tls') === 'tls' ? 'selected' : '' }}>TLS</option>
                            <option value="ssl" {{ ($settings['email']['smtp_encryption'] ?? '') === 'ssl' ? 'selected' : '' }}>SSL</option>
                        </x-select>

                        <x-input 
                            :label="admin_trans('from_name')"
                            name="from_name"
                            value="{{ $settings['email']['from_name'] ?? 'Qansah' }}"
                            :required="true"
                        />

                        <x-input 
                            :label="admin_trans('from_address')"
                            name="from_address"
                            type="email"
                            value="{{ $settings['email']['from_address'] ?? '' }}"
                            :required="true"
                        />
                    </div>

                    <!-- Test Email Section -->
                    <div class="border-t pt-6" style="border-color: var(--color-border);">
                        <h3 class="text-lg font-semibold mb-4 text-primary">{{ admin_trans('test_email_configuration') }}</h3>
                        <div class="flex gap-4">
                            <x-input 
                                :label="admin_trans('test_email_address')"
                                name="test_email"
                                type="email"
                                placeholder="test@example.com"
                                class="flex-1"
                            />
                            <div class="flex items-end">
                                <x-button 
                                    type="button" 
                                    variant="secondary" 
                                    icon="send"
                                    onclick="sendTestEmail()"
                                >
                                    {{ admin_trans('send_test_email') }}
                                </x-button>
                            </div>
                        </div>
                    </div>

                    <div class="flex justify-end">
                        <x-button variant="primary" type="submit" icon="check">
                            {{ admin_trans('save_changes') }}
                        </x-button>
                    </div>
                </form>
            </x-tab-content>

            <!-- Social Media Settings Tab -->
            <x-tab-content tab="social" class="p-6">
                <form method="POST" action="{{ route('admin.settings.social') }}" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <x-input 
                            :label="admin_trans('facebook_app_id')"
                            name="facebook_app_id"
                            value="{{ $settings['social']['facebook_app_id'] ?? '' }}"
                            :hint="admin_trans('facebook_app_id_hint')"
                        />

                        <x-input 
                            :label="admin_trans('google_client_id')"
                            name="google_client_id"
                            value="{{ $settings['social']['google_client_id'] ?? '' }}"
                            :hint="admin_trans('google_client_id_hint')"
                        />
                    </div>

                    <div class="flex justify-end">
                        <x-button variant="primary" type="submit" icon="check">
                            {{ admin_trans('save_changes') }}
                        </x-button>
                    </div>
                </form>
            </x-tab-content>

            <!-- SEO Settings Tab (Country-specific) -->
            <x-tab-content tab="seo" class="p-6">

                <div class="mb-6">
                <!-- Country Notice -->
                @if($currentCountry)
                    <x-alert class="mb-6">
                        <strong>{{ admin_trans('country_specific_settings') }}:</strong>
                        <br>
                        {{ admin_trans('these_settings_apply_to') }} <strong>{{ $currentCountry->name }}</strong>
                    </x-alert>
                @else
                    <x-alert variant="warning" icon="alert-triangle" class="mb-6">
                        <strong>{{ admin_trans('global_settings') }}:</strong>
                        {{ admin_trans('no_country_selected_global_seo') }}
                    </x-alert>
                @endif

                </div>
                <form method="POST" action="{{ route('admin.settings.seo') }}" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <x-input 
                        :label="admin_trans('meta_title_template')"
                        name="meta_title_template"
                        value="{{ $settings['seo']['meta_title_template'] ?? '%s - Qansah' }}"
                        :required="true"
                        :hint="admin_trans('use_s_for_page_title')"
                    />

                    <x-textarea 
                        :label="admin_trans('meta_description_template')"
                        name="meta_description_template"
                        :required="true"
                        rows="3"
                    >{{ $settings['seo']['meta_description_template'] ?? '' }}</x-textarea>

                    <x-textarea 
                        :label="admin_trans('meta_keywords')"
                        name="meta_keywords"
                        :hint="admin_trans('separate_with_commas')"
                        rows="2"
                    >{{ $settings['seo']['meta_keywords'] ?? '' }}</x-textarea>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <x-input 
                            :label="admin_trans('google_analytics_id')"
                            name="google_analytics_id"
                            value="{{ $settings['seo']['google_analytics_id'] ?? '' }}"
                            placeholder="G-XXXXXXXXXX"
                        />

                        <x-input 
                            :label="admin_trans('facebook_pixel_id')"
                            name="facebook_pixel_id"
                            value="{{ $settings['seo']['facebook_pixel_id'] ?? '' }}"
                            placeholder="123456789"
                        />

                        <x-input 
                            :label="admin_trans('google_tag_manager')"
                            name="google_tag_manager"
                            value="{{ $settings['seo']['google_tag_manager'] ?? '' }}"
                            placeholder="GTM-XXXXXXX"
                        />
                    </div>

                    <!-- Copy SEO Settings Section -->
                    @if($countries->count() > 1)
                        <div class="border-t pt-6" style="border-color: var(--color-border);">
                            <h3 class="text-lg font-semibold mb-4 text-primary">{{ admin_trans('copy_seo_settings') }}</h3>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                                <x-select :label="admin_trans('copy_from_country')" id="from_country">
                                    <option value="">{{ admin_trans('select_country') }}</option>
                                    @foreach($countries as $country)
                                        <option value="{{ $country->id }}">{{ $country->name }}</option>
                                    @endforeach
                                </x-select>

                                <x-select :label="admin_trans('copy_to_country')" id="to_country">
                                    <option value="">{{ admin_trans('select_country') }}</option>
                                    @foreach($countries as $country)
                                        <option value="{{ $country->id }}">{{ $country->name }}</option>
                                    @endforeach
                                </x-select>

                                <x-button 
                                    type="button" 
                                    variant="secondary" 
                                    icon="copy"
                                    onclick="copySeoSettings()"
                                >
                                    {{ admin_trans('copy_settings') }}
                                </x-button>
                            </div>
                        </div>
                    @endif

                    <div class="flex justify-end">
                        <x-button variant="primary" type="submit" icon="check">
                            {{ admin_trans('save_changes') }}
                        </x-button>
                    </div>
                </form>
            </x-tab-content>

            <!-- Cache Settings Tab -->
            <x-tab-content tab="cache" class="p-6">
                <form method="POST" action="{{ route('admin.settings.cache') }}" class="space-y-6">
                    @csrf
                    @method('PUT')

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <x-toggle 
                            :label="admin_trans('enable_cache')"
                            name="cache_enabled"
                            :checked="($settings['cache']['cache_enabled'] ?? true)"
                            :description="admin_trans('cache_enable_hint')"
                        />

                        <x-select 
                            :label="admin_trans('cache_driver')"
                            name="cache_driver"
                            :required="true"
                        >
                            <option value="file" {{ ($settings['cache']['cache_driver'] ?? 'file') === 'file' ? 'selected' : '' }}>{{ admin_trans('file') }}</option>
                            <option value="redis" {{ ($settings['cache']['cache_driver'] ?? '') === 'redis' ? 'selected' : '' }}>Redis</option>
                            <option value="memcached" {{ ($settings['cache']['cache_driver'] ?? '') === 'memcached' ? 'selected' : '' }}>Memcached</option>
                        </x-select>

                        <x-input 
                            :label="admin_trans('cache_lifetime')"
                            name="cache_lifetime"
                            type="number"
                            value="{{ $settings['cache']['cache_lifetime'] ?? '3600' }}"
                            :required="true"
                            :hint="admin_trans('seconds')"
                        />
                    </div>

                    <!-- Cache Actions -->
                    <div class="border-t pt-6" style="border-color: var(--color-border);">
                        <h3 class="text-lg font-semibold mb-4 text-primary">{{ admin_trans('cache_management') }}</h3>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                            <x-button 
                                type="button" 
                                variant="outline" 
                                icon="trash-2"
                                onclick="clearCache('all')"
                                class="w-full"
                            >
                                {{ admin_trans('clear_all_cache') }}
                            </x-button>

                            <x-button 
                                type="button" 
                                variant="outline" 
                                icon="refresh-cw"
                                onclick="clearCache('config')"
                                class="w-full"
                            >
                                {{ admin_trans('clear_config_cache') }}
                            </x-button>

                            <x-button 
                                type="button" 
                                variant="outline" 
                                icon="route"
                                onclick="clearCache('route')"
                                class="w-full"
                            >
                                {{ admin_trans('clear_route_cache') }}
                            </x-button>

                            <x-button 
                                type="button" 
                                variant="outline" 
                                icon="eye"
                                onclick="clearCache('view')"
                                class="w-full"
                            >
                                {{ admin_trans('clear_view_cache') }}
                            </x-button>
                        </div>
                    </div>

                    <div class="flex justify-end">
                        <x-button variant="primary" type="submit" icon="check">
                            {{ admin_trans('save_changes') }}
                        </x-button>
                    </div>
                </form>
            </x-tab-content>

        </x-tabs>
    </div>
</div>

@endsection

@push('scripts')
<script>
// Send test email
function sendTestEmail() {
    const email = document.querySelector('input[name="test_email"]').value;
    
    if (!email) {
        toast.error('{{ admin_trans("please_enter_email") }}');
        return;
    }

    fetch('{{ route("admin.settings.test-email") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ test_email: email })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            toast.success('{{ admin_trans("test_email_sent") }}');
        } else {
            toast.error(data.message || '{{ admin_trans("test_email_failed") }}');
        }
    })
    .catch(error => {
        toast.error('{{ admin_trans("test_email_failed") }}');
    });
}

// Copy SEO settings between countries
function copySeoSettings() {
    const fromCountry = document.getElementById('from_country').value;
    const toCountry = document.getElementById('to_country').value;
    
    if (!fromCountry || !toCountry) {
        toast.error('{{ admin_trans("please_select_both_countries") }}');
        return;
    }

    if (fromCountry === toCountry) {
        toast.error('{{ admin_trans("cannot_copy_to_same_country") }}');
        return;
    }

    if (confirm('{{ admin_trans("confirm_copy_seo_settings") }}')) {
        fetch('{{ route("admin.settings.copy-seo") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ 
                from_country_id: fromCountry,
                to_country_id: toCountry
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                toast.success('{{ admin_trans("seo_settings_copied") }}');
                setTimeout(() => location.reload(), 1500);
            } else {
                toast.error(data.message || '{{ admin_trans("error_copying_settings") }}');
            }
        })
        .catch(error => {
            toast.error('{{ admin_trans("error_copying_settings") }}');
        });
    }
}

// Clear cache functions
function clearCache(type = 'all') {
    if (confirm('{{ admin_trans("confirm_clear_cache") }}')) {
        fetch('{{ route("admin.settings.clear-cache") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ type: type })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                toast.success('{{ admin_trans("cache_cleared") }}');
            } else {
                toast.error('{{ admin_trans("error_clearing_cache") }}');
            }
        })
        .catch(error => {
            toast.error('{{ admin_trans("error_clearing_cache") }}');
        });
    }
}
</script>
@endpush