<!DOCTYPE html>
<html lang="{{ admin_locale() }}" dir="{{ is_rtl() ? 'rtl' : 'ltr' }}" x-data>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ admin_trans('login') }} - Qansah</title>
    <script src="https://unpkg.com/lucide@latest"></script>

    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="antialiased" style="background: var(--color-bg-secondary); min-height: 100vh;">
    
    <!-- Theme Toggle (Top Right) -->
    <div class="absolute top-6 z-50" style="{{ is_rtl() ? 'left: 1.5rem;' : 'right: 1.5rem;' }}">
        <button 
            @click="$store.theme.toggle()"
            type="button"
            class="p-3 rounded-xl hover:scale-105 transition-all duration-200"
            style="background: var(--color-bg-primary); border: 1px solid var(--color-border); color: var(--color-text-primary); box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);"
        >
            <!-- Sun Icon (Light Mode) -->
            <svg x-show="$store.theme.mode === 'light'" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"/>
            </svg>
            <!-- Moon Icon (Dark Mode) -->
            <svg x-show="$store.theme.mode === 'dark'" x-cloak class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"/>
            </svg>
        </button>
    </div>

    <!-- Language Toggle (Top Left) -->
    <div class="absolute top-6 z-50" style="{{ is_rtl() ? 'right: 1.5rem;' : 'left: 1.5rem;' }}">
        <a 
            href="{{ route('admin.locale', admin_locale() === 'ar' ? 'en' : 'ar') }}"
            class="px-4 py-3 rounded-xl font-semibold transition-all duration-200 inline-flex items-center gap-2 hover:scale-105"
            style="background: var(--color-bg-primary); border: 1px solid var(--color-border); color: var(--color-text-primary); text-decoration: none; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);"
        >
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5h12M9 3v2m1.048 9.5A18.022 18.022 0 016.412 9m6.088 9h7M11 21l5-10 5 10M12.751 5C11.783 10.77 8.07 15.61 3 18.129"/>
            </svg>
            {{ admin_locale() === 'ar' ? admin_trans('english') : admin_trans('arabic') }}
        </a>
    </div>

    <!-- Main Content -->
    <div class="flex items-center justify-center min-h-screen px-4">
        @yield('content')
    </div>

    <style>
        [x-cloak] { display: none !important; }
    </style>

</body>
<script>
    // Initialize Lucide icons
    lucide.createIcons();
</script>


</html>