@extends('admin.layouts.app')

@section('title', $carousel->name . ' - ' . admin_trans('slides'))
@section('page-title', $carousel->name)

@section('content')

<div class="space-y-6" x-data="carouselSlidesPage()">

    <!-- Breadcrumb & Actions -->
    <div class="card">
        <div class="flex flex-col sm:flex-row gap-4 items-start sm:items-center justify-between">
            
            <!-- Breadcrumb -->
            <div class="flex items-center gap-2 text-sm">
                <a href="{{ route('admin.carousels.index') }}" class="text-secondary hover:text-primary transition-colors">
                    {{ admin_trans('carousels') }}
                </a>
                <i data-lucide="chevron-right" class="w-4 h-4 text-tertiary"></i>
                <span class="text-primary font-medium">{{ $carousel->name }}</span>
            </div>

            <!-- Actions -->
            <div class="flex items-center gap-3">
                <x-badge :variant="$carousel->is_active ? 'success' : 'secondary'">
                    {{ $carousel->is_active ? admin_trans('active') : admin_trans('inactive') }}
                </x-badge>
                
                @if($currentCountry && $availableLocales->count() > 0)
                    <x-button variant="primary" icon="plus" @click="$dispatch('open-modal', 'create-slide-modal')">
                        {{ admin_trans('add_slide') }}
                    </x-button>
                @else
                    <x-button variant="outline" icon="alert-circle" disabled>
                        @if(!$currentCountry)
                            {{ admin_trans('select_country_first') }}
                        @else
                            {{ admin_trans('create_locale_first') }}
                        @endif
                    </x-button>
                @endif
            </div>
        </div>
    </div>

    <!-- Country/Locale Warning -->
    @if(!$currentCountry)
        <x-alert variant="warning" icon="alert-triangle">
            <div>
                <h4 class="font-semibold mb-1">{{ admin_trans('select_country_first') }}</h4>
                <p class="text-sm">{{ admin_trans('use_country_filter_navbar') }}</p>
            </div>
        </x-alert>
    @elseif($availableLocales->count() == 0)
        <x-alert variant="warning" icon="alert-triangle">
            <div>
                <h4 class="font-semibold mb-1">{{ admin_trans('no_locales_available') }}</h4>
                <p class="text-sm">{{ admin_trans('please_create_locale_for_country') }} <strong>{{ $currentCountry->name }}</strong></p>
                <a href="{{ route('admin.locales.index') }}" class="inline-flex items-center gap-2 mt-3 px-4 py-2 bg-white rounded-lg border border-yellow-300 hover:bg-yellow-50 transition-colors">
                    <i data-lucide="plus" class="w-4 h-4"></i>
                    {{ admin_trans('create_locale') }}
                </a>
            </div>
        </x-alert>
    @endif

<!-- Carousel Info - Horizontal Grid -->
<div class="card">
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
        
        <!-- Total Slides -->
        <div class="flex items-center gap-3 p-4 rounded-xl bg-primary-light">
            <div class="w-12 h-12 rounded-xl flex items-center justify-center gradient-primary flex-shrink-0">
                <i data-lucide="images" class="w-6 h-6 text-white"></i>
            </div>
            <div class="min-w-0 flex-1">
                <p class="text-xs text-tertiary mb-1">{{ admin_trans('total_slides') }}</p>
                <h3 class="text-2xl font-bold text-primary">{{ $carousel->slides->count() }}</h3>
            </div>
        </div>
<!-- Slug -->
<div class="flex items-center gap-3 p-4 rounded-xl transition-all hover:shadow-md" style="background: linear-gradient(135deg, rgba(168, 85, 247, 0.08) 0%, rgba(236, 72, 153, 0.08) 100%); border: 1px solid rgba(168, 85, 247, 0.15);">
    <div class="w-12 h-12 rounded-xl flex items-center justify-center flex-shrink-0 shadow-sm transition-transform hover:scale-105" style="background: linear-gradient(135deg, #A855F7 0%, #EC4899 100%);">
        <i data-lucide="hash" class="w-6 h-6 text-white"></i>
    </div>
    <div class="min-w-0 flex-1">
        <p class="text-xs font-medium text-tertiary mb-1">{{ admin_trans('slug') }}</p>
        <h3 class="text-sm font-bold text-primary truncate">{{ $carousel->slug }}</h3>
    </div>
</div>


        <!-- Type -->
        <div class="flex items-center gap-3 p-4 rounded-xl" style="background: rgba(139, 92, 246, 0.1);">
            <div class="w-12 h-12 rounded-xl flex items-center justify-center flex-shrink-0" style="background: #8B5CF6;">
                <i data-lucide="layout" class="w-6 h-6 text-white"></i>
            </div>
            <div class="min-w-0 flex-1">
                <p class="text-xs text-tertiary mb-1">{{ admin_trans('type') }}</p>
                <h3 class="text-sm font-semibold text-primary truncate">{{ $carousel->type }}</h3>
            </div>
        </div>

<!-- Country -->
@if($currentCountry)
    <div class="flex items-center gap-3 p-4 rounded-xl transition-all hover:shadow-md" style="background: linear-gradient(135deg, rgba(22, 204, 98, 0.08) 0%, rgba(19, 184, 85, 0.08) 100%); border: 1px solid rgba(22, 204, 98, 0.15);">
        <div class="w-12 h-12 rounded-xl flex items-center justify-center flex-shrink-0 shadow-sm transition-transform hover:scale-105" style="background: linear-gradient(135deg, #16CC62 0%, #13B855 100%);">
            <span class="text-2xl mb-2">{{ $currentCountry->flag_emoji }}</span>
        </div>
        <div class="min-w-0 flex-1">
            <p class="text-xs font-medium text-tertiary mb-1">{{ admin_trans('country') }}</p>
            <h3 class="text-sm font-bold text-primary truncate">{{ $currentCountry->name }}</h3>
        </div>
    </div>
@endif

    </div>
</div>

    <!-- Slides Grid -->
    @if($carousel->slides->isEmpty())
        <x-card>
            <x-empty-state icon="image" :title="admin_trans('no_slides_yet')" :description="admin_trans('start_by_adding_first_slide')">
                @if($currentCountry && $availableLocales->count() > 0)
                    <x-button variant="primary" icon="plus" @click="$dispatch('open-modal', 'create-slide-modal')">
                        {{ admin_trans('add_slide') }}
                    </x-button>
                @endif
            </x-empty-state>
        </x-card>
    @else
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
@foreach($carousel->slides as $slide)
    <div class="card hover:shadow-xl transition-all">
<!-- Image -->
@if($slide->getFirstMediaUrl('image'))
    <div class="relative mb-4 rounded-xl overflow-hidden shadow-md" style="height: 220px;">
        <img src="{{ $slide->getFirstMediaUrl('image') }}" 
             alt="Slide" 
             class="w-full h-full object-cover transition-transform duration-300 hover:scale-105">
        
        <!-- Gradient Overlay -->
        <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-0 hover:opacity-100 transition-opacity duration-300"></div>
    </div>
@else
    <div class="mb-4 rounded-xl bg-gradient-to-br from-gray-100 to-gray-200 flex flex-col items-center justify-center shadow-inner" style="height: 220px;">
        <i data-lucide="image-off" class="w-16 h-16 text-gray-400 mb-2"></i>
        <p class="text-sm text-gray-500 font-medium">{{ admin_trans('no_image') }}</p>
    </div>
@endif

        <!-- Content -->
        <div class="space-y-3">
            @php
                $translation = $slide->translations->first();
            @endphp

            @if($translation)
                <div>
                    <h3 class="text-lg font-semibold text-primary mb-1">
                        {{ $translation->title }}
                    </h3>
                    @if($translation->description)
                        <p class="text-sm text-tertiary line-clamp-2">
                            {{ $translation->description }}
                        </p>
                    @endif
                </div>
            @endif

            <!-- Languages -->
            <div class="flex items-center gap-1 flex-wrap">
                @foreach($slide->translations->take(5) as $trans)
                    <x-badge variant="info" class="text-xs">
                        {{ $trans->locale->code ?? 'N/A' }}
                    </x-badge>
                @endforeach
                @if($slide->translations->count() > 5)
                    <x-badge variant="secondary" class="text-xs">
                        +{{ $slide->translations->count() - 5 }}
                    </x-badge>
                @endif
            </div>

            <!-- Link Info -->
            @if($slide->linkable)
                <div class="flex items-center gap-2 text-xs">
                    <i data-lucide="link" class="w-3 h-3 text-secondary"></i>
                    <span class="text-secondary">
                        {{ class_basename($slide->linkable_type) }}
                    </span>
                </div>
            @endif

            <!-- Actions Buttons -->
            <div class="flex items-center gap-2 pt-3 border-t" style="border-color: var(--color-border);">
                <button type="button" onclick="editSlide({{ $slide->id }})" class="flex-1 px-3 py-2 rounded-lg bg-blue-50 text-blue-600 hover:bg-blue-100 transition-colors flex items-center justify-center gap-2">
                    <i data-lucide="edit-3" class="w-4 h-4"></i>
                    <span class="text-sm font-medium">{{ admin_trans('edit') }}</span>
                </button>
                <button type="button" onclick="confirmDeleteSlide({{ $slide->id }})" class="flex-1 px-3 py-2 rounded-lg bg-red-50 text-red-600 hover:bg-red-100 transition-colors flex items-center justify-center gap-2">
                    <i data-lucide="trash-2" class="w-4 h-4"></i>
                    <span class="text-sm font-medium">{{ admin_trans('delete') }}</span>
                </button>
            </div>
        </div>
    </div>
@endforeach
        </div>
    @endif
</div>

<!-- Create Slide Modal -->
<x-modal name="create-slide-modal" maxWidth="3xl">
    <div class="p-6">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-xl font-bold text-primary">{{ admin_trans('add_slide') }}</h3>
            <button @click="$dispatch('close-modal', 'create-slide-modal')" class="p-2 rounded-lg hover:bg-primary-light">
                <i data-lucide="x" class="w-5 h-5 text-tertiary"></i>
            </button>
        </div>

        @if($currentCountry && $availableLocales->count() > 0)
            <form method="POST" action="{{ route('admin.carousels.slides.store', $carousel) }}" enctype="multipart/form-data" class="space-y-6">
                @csrf
                
                <!-- Current Context -->
                <x-alert variant="info" icon="info">
                    <div class="flex items-center gap-3">
                        <span class="text-2xl mb-2">{{ $currentCountry->flag_emoji }}</span>
                        <div>
                            <h4 class="font-semibold">{{ admin_trans('creating_slide_for') }}</h4>
                            <p class="text-sm opacity-75">{{ $currentCountry->getName() }}</p>
                        </div>
                    </div>
                </x-alert>

                <!-- Multi-language Tabs -->
                <x-tabs defaultTab="{{ $availableLocales->first()->id }}">
                    <div class="flex flex-wrap gap-2 border-b mb-4" style="border-color: var(--color-border);">
                        @foreach($availableLocales as $locale)
                            <button type="button" @click="activeTab = '{{ $locale->id }}'; $event.preventDefault();"
                                :class="activeTab === '{{ $locale->id }}' ? 'text-primary bg-primary-light' : 'text-tertiary hover:text-primary'"
                                class="flex items-center gap-2 px-4 py-2 border-b transition-colors font-medium">
                                <i data-lucide="globe" class="w-4 h-4"></i>
                                {{ $locale->language->name ?? $locale->name }}
                            </button>
                        @endforeach
                    </div>

                    @foreach($availableLocales as $locale)
                        <x-tab-content :tab="$locale->id">
                            <div class="space-y-4">
                                <x-input :label="admin_trans('slide_title')" name="translations[{{ $locale->id }}][title]" placeholder="{{ admin_trans('enter_slide_title') }}" :required="$loop->first" />
                                <x-textarea :label="admin_trans('description')" name="translations[{{ $locale->id }}][description]" rows="3" placeholder="{{ admin_trans('enter_description') }}" />
                                <x-input :label="admin_trans('button_text')" name="translations[{{ $locale->id }}][button_text]" placeholder="{{ admin_trans('enter_button_text') }}" />
                                <x-input :label="admin_trans('button_link')" name="translations[{{ $locale->id }}][button_link]" type="url" placeholder="https://example.com" />
                            </div>
                        </x-tab-content>
                    @endforeach
                </x-tabs>

                <!-- Link Type -->
                <div x-data="{ linkType: '', selectedStore: '', selectedCategory: '' }">
                    <x-select :label="admin_trans('link_to')" name="linkable_type_select" x-model="linkType">
                        <option value="">{{ admin_trans('no_link') }}</option>
                        <option value="store">{{ admin_trans('link_to_store') }}</option>
                        <option value="category">{{ admin_trans('link_to_category') }}</option>
                    </x-select>

                    <!-- Store Selection -->
                    <div x-show="linkType === 'store'" x-cloak class="mt-4">
                        @php
                            $storesArray = $stores->map(function($store) {
                                $translation = $store->translations->first();
                                return [
                                    'id' => $store->id,
                                    'name' => $translation->name ?? 'Store #' . $store->id
                                ];
                            })->toArray();
                        @endphp
                        <div x-data="{ storeValue: '' }" x-init="$watch('storeValue', val => selectedStore = val)">
                            <x-searchable-select
                                name="linkable_id_store"
                                :label="admin_trans('select_store')"
                                :placeholder="admin_trans('search_stores')"
                                :options="$storesArray"
                                valueKey="id"
                                labelKey="name"
                                watchValue="storeValue"
                            />
                        </div>
                        <input type="hidden" name="linkable_type" x-bind:value="linkType === 'store' ? 'App\\Models\\Store' : ''">
                        <input type="hidden" name="linkable_id" x-bind:value="linkType === 'store' ? selectedStore : ''">
                    </div>

                    <!-- Category Selection -->
                    <div x-show="linkType === 'category'" x-cloak class="mt-4">
                        @php
                            $categoriesArray = $categories->map(function($category) {
                                $translation = $category->translations->first();
                                return [
                                    'id' => $category->id,
                                    'name' => $translation->name ?? 'Category #' . $category->id
                                ];
                            })->toArray();
                        @endphp
                        <div x-data="{ categoryValue: '' }" x-init="$watch('categoryValue', val => selectedCategory = val)">
                            <x-searchable-select
                                name="linkable_id_category"
                                :label="admin_trans('select_category')"
                                :placeholder="admin_trans('search_categories')"
                                :options="$categoriesArray"
                                valueKey="id"
                                labelKey="name"
                                watchValue="categoryValue"
                            />
                        </div>
                        <input type="hidden" name="linkable_type" x-bind:value="linkType === 'category' ? 'App\\Models\\Category' : ''">
                        <input type="hidden" name="linkable_id" x-bind:value="linkType === 'category' ? selectedCategory : ''">
                    </div>
                </div>

                <!-- Image Upload -->
                <x-file-upload :label="admin_trans('slide_image')" name="image" accept="image/*" maxSize="5MB" :required="true" />

                <div class="flex gap-3 justify-end pt-4 border-t" style="border-color: var(--color-border);">
                    <x-button variant="outline" type="button" @click="$dispatch('close-modal', 'create-slide-modal')">{{ admin_trans('cancel') }}</x-button>
                    <x-button variant="primary" type="submit" icon="check">{{ admin_trans('create') }}</x-button>
                </div>
            </form>
        @else
            <x-empty-state icon="globe" :title="admin_trans('select_country_first')" :description="admin_trans('use_country_filter_navbar')">
                <x-button variant="outline" @click="$dispatch('close-modal', 'create-slide-modal')">{{ admin_trans('close') }}</x-button>
            </x-empty-state>
        @endif
    </div>
</x-modal>

<!-- Edit Slide Modal -->
<x-modal name="edit-slide-modal" maxWidth="3xl">
    <div class="p-6" x-data="editSlideModal()">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-xl font-bold text-primary">{{ admin_trans('edit_slide') }}</h3>
            <button @click="$dispatch('close-modal', 'edit-slide-modal')" class="p-2 rounded-lg hover:bg-primary-light">
                <i data-lucide="x" class="w-5 h-5 text-tertiary"></i>
            </button>
        </div>

        <div x-show="loading">
            <x-loading text="{{ admin_trans('loading') }}..." />
        </div>

        <div x-show="!loading && slideData" x-cloak>
            <form :action="`/admin/carousels/slides/${slideData?.id}`" method="POST" enctype="multipart/form-data" class="space-y-6">
                @csrf @method('PUT')
                
                @if($availableLocales->count() > 0)
                    <x-tabs defaultTab="{{ $availableLocales->first()->id }}">
                        <div class="flex flex-wrap gap-2 border-b mb-4" style="border-color: var(--color-border);">
                            @foreach($availableLocales as $locale)
                                <button type="button" @click="activeTab = '{{ $locale->id }}'; $event.preventDefault();"
                                    :class="activeTab === '{{ $locale->id }}' ? 'text-primary bg-primary-light' : 'text-tertiary hover:text-primary'"
                                    class="flex items-center gap-2 px-4 py-2 border-b transition-colors font-medium">
                                    <i data-lucide="globe" class="w-4 h-4"></i>
                                    {{ $locale->language->name ?? $locale->name }}
                                </button>
                            @endforeach
                        </div>

                        @foreach($availableLocales as $locale)
                            <x-tab-content :tab="$locale->id">
                                <div class="space-y-4">
                                    <x-input 
                                        :label="admin_trans('slide_title')" 
                                        :name="'translations[' . $locale->id . '][title]'"
                                        x-bind:value="getTranslationValue({{ $locale->id }}, 'title')"
                                        @input="setTranslationValue({{ $locale->id }}, 'title', $event.target.value)"
                                    />
                                    <x-textarea 
                                        :label="admin_trans('description')" 
                                        :name="'translations[' . $locale->id . '][description]'" 
                                        rows="3"
                                        x-bind:value="getTranslationValue({{ $locale->id }}, 'description')"
                                        @input="setTranslationValue({{ $locale->id }}, 'description', $event.target.value)"
                                    />
                                    <x-input 
                                        :label="admin_trans('button_text')" 
                                        :name="'translations[' . $locale->id . '][button_text]'"
                                        x-bind:value="getTranslationValue({{ $locale->id }}, 'button_text')"
                                        @input="setTranslationValue({{ $locale->id }}, 'button_text', $event.target.value)"
                                    />
                                    <x-input 
                                        :label="admin_trans('button_link')" 
                                        :name="'translations[' . $locale->id . '][button_link]'" 
                                        type="url"
                                        x-bind:value="getTranslationValue({{ $locale->id }}, 'button_link')"
                                        @input="setTranslationValue({{ $locale->id }}, 'button_link', $event.target.value)"
                                    />
                                </div>
                            </x-tab-content>
                        @endforeach
                    </x-tabs>
                @endif

                <!-- Image Upload -->
                <div>
                    <x-file-upload :label="admin_trans('slide_image')" name="image" accept="image/*" maxSize="5MB" />
<div x-show="slideData?.image_url" class="mt-3">
    <label class="block text-sm font-semibold mb-2 text-primary">{{ admin_trans('current_image') }}</label>
    <div class="relative w-full max-w-md">
        <img :src="slideData?.image_url" alt="Current Image" class="w-full h-auto max-h-64 object-cover rounded-xl border-2 shadow-sm" style="border-color: var(--color-border);">
    </div>
</div>
                </div>

                <div class="flex gap-3 justify-end pt-4 border-t" style="border-color: var(--color-border);">
                    <x-button variant="outline" type="button" @click="$dispatch('close-modal', 'edit-slide-modal')">{{ admin_trans('cancel') }}</x-button>
                    <x-button variant="primary" type="submit" icon="check">{{ admin_trans('update') }}</x-button>
                </div>
            </form>
        </div>
    </div>
</x-modal>

<!-- Delete Slide Confirmation -->
<x-confirm-modal name="delete-slide-modal" :title="admin_trans('confirm_delete')" :message="admin_trans('delete_slide_message')" :confirmText="admin_trans('yes_delete')" :cancelText="admin_trans('cancel')" confirmVariant="danger" icon="trash-2" iconColor="danger" />

@endsection

@push('scripts')
<script>
function carouselSlidesPage() {
    return {
        init() {
            // Listen to country filter changes - redirect to index
            window.addEventListener('country-filter-changed', () => {
                if (window.toast) {
                    toast.info('{{ admin_trans("country_changed_redirecting") }}...');
                }
                setTimeout(() => {
                    window.location.href = '{{ route("admin.carousels.index") }}';
                }, 500);
            });
        }
    }
}

function editSlideModal() {
    return {
        loading: false,
        slideData: null,

        async loadSlide(id) {
            this.loading = true;
            try {
                const response = await fetch(`/admin/carousels/slides/${id}/edit`);
                const result = await response.json();
                if (result.success) {
                    this.slideData = result.data;
                    console.log('Slide loaded:', this.slideData);
                }
            } catch (error) {
                console.error('Error loading slide:', error);
                if (window.toast) {
                    toast.error('{{ admin_trans("error_loading_slide") }}');
                }
            } finally {
                this.loading = false;
            }
        },

        getTranslationValue(localeId, field) {
            const translation = this.slideData?.translations?.find(t => t.locale_id == localeId);
            return translation ? translation[field] || '' : '';
        },

        setTranslationValue(localeId, field, value) {
            if (!this.slideData || !this.slideData.translations) return;
            let translation = this.slideData.translations.find(t => t.locale_id == localeId);
            if (!translation) {
                translation = { locale_id: localeId };
                this.slideData.translations.push(translation);
            }
            translation[field] = value;
        }
    }
}

function editSlide(id) {
    console.log('Opening edit modal for slide:', id);
    window.dispatchEvent(new CustomEvent('open-modal', { detail: 'edit-slide-modal' }));
    setTimeout(() => {
        const modal = document.querySelector('[x-data*="editSlideModal"]');
        if (modal && modal._x_dataStack) {
            modal._x_dataStack[0].loadSlide(id);
        }
    }, 100);
}

function confirmDeleteSlide(id) {
    window.addEventListener('confirm-action', function handler(e) {
        if (e.detail === 'delete-slide-modal') {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/admin/carousels/slides/${id}`;
            form.innerHTML = '@csrf @method("DELETE")';
            document.body.appendChild(form);
            form.submit();
            window.removeEventListener('confirm-action', handler);
        }
    });
    window.dispatchEvent(new CustomEvent('open-modal', { detail: 'delete-slide-modal' }));
}

// Show validation errors in toast
document.addEventListener('DOMContentLoaded', function() {
    @if($errors->any())
        @foreach($errors->all() as $error)
            if (window.toast) {
                toast.error('{{ $error }}', '{{ admin_trans("validation_error") }}');
            }
        @endforeach
    @endif
    
    if (typeof lucide !== 'undefined') {
        lucide.createIcons();
    }
});
</script>
@endpush